package gov.va.med.edp.web.servlet.filter;

import javax.servlet.*;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Enumeration;
//import org.apache.log4j.Logger;

/**
 * Servlet filter that sets HTTP Response Headers based on initialization parameters.
 * <p/>
 * Example usage in web.xml of servlet application:
 * <code>
 * <filter>
 * <filter-name>responseHeaderFilter</filter-name>
 * <filter-class>gov.va.med.edp.web.servlet.filter.ResponseHeaderFilter</filter-class>
 * <init-param>
 * <param-name>Cache-Control</param-name>
 * <param-value>max-age=3600</param-value>
 * </init-param>
 * </filter>
 * ...
 * <filter-mapping>
 * <filter-name>responseHeaderFilter</filter-name>
 * <url-pattern>/logo.png</url-pattern>
 * </filter-mapping>
 * </code>
 */
public class ResponseHeaderFilter implements Filter {

	//private static Logger log = Logger.getLogger(ResponseHeaderFilter.class);
	
    FilterConfig filterConfig;
    /*public ResponseHeaderFilter(FilterConfig filterConfig) {
		super();
		debug("->ResponseHeaderFilter");
	}*/
	/* (non-Javadoc)
     * @see javax.servlet.Filter#init(javax.servlet.FilterConfig)
     */
	 /**
	  *  Set the initialization parameters.
	  * @param filterConfig The Config parameter set.
	  */
    public void init(FilterConfig filterConfig) throws ServletException {      
    	
    	if(filterConfig != null) {
    	//	debug("->init filterConfig " + filterConfig.toString());
    	} else {
    	//	debug("->init filterConfig == null ");
    	}
    	
    	this.filterConfig = filterConfig;
    }
    /* (non-Javadoc)
     * @see javax.servlet.Filter#doFilter(javax.servlet.ServletRequest, javax.servlet.ServletResponse, javax.servlet.FilterChain)
     */
	 /**
	  *  Filter the HTTP request.
	  * @param req The HTTP request.
	  * @param res The HTTP response.
	  * @param filterChain The filter chain set.
	  */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain filterChain) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse) res;
   //     debug("->doFilter response " + response);
        // set the provided HTTP response parameters
        for (Enumeration e = filterConfig.getInitParameterNames(); e.hasMoreElements();) {
            String headerName = (String) e.nextElement();
            String parameterName = filterConfig.getInitParameter(headerName);
            response.addHeader(headerName, parameterName);
     //       debug("->doFilter addHeader(headerName=" + headerName + " , parameterName=" + parameterName + ")");
        }

        filterChain.doFilter(req, response);
    }
    /* (non-Javadoc)
     * @see javax.servlet.Filter#destroy()
     */
	 /**
	  * Set the filter chain to null.
	  */
    public void destroy() {
    //	debug("->destroy");
        this.filterConfig = null;
    }
    
   // private void debug(String s) {
  //  	if (log.isDebugEnabled()){
    ////.debug(s);
   // 	}
	//} 
}
