package gov.va.med.edp.web.handler;

import org.springframework.web.servlet.handler.SimpleMappingExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
/**
 * Resolves an exception and passes back a model.
 */
public class ExceptionResolver extends SimpleMappingExceptionResolver{
	/* (non-Javadoc)
	 * @see org.springframework.web.servlet.handler.SimpleMappingExceptionResolver#getModelAndView(java.lang.String, java.lang.Exception, javax.servlet.http.HttpServletRequest)
	 */
	/**
	 *  Retrieve the ModelAndView associated with the given view.
	 * @param viewName The current view.
	 * @param ex The exception.
	 * @param request The HTTP request.
	 * @return The ModelAndView
	 */
	protected ModelAndView getModelAndView(String viewName, Exception ex, HttpServletRequest request) {
        ModelAndView mav = super.getModelAndView(viewName, ex, request);
        mav.addObject("resource", request.getRequestURI());
        return mav;
    }
}
