package gov.va.med.edp.web.controller;

import org.springframework.web.servlet.mvc.AbstractController;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.util.StringUtils;
import org.springframework.util.Assert;
import org.springframework.beans.factory.InitializingBean;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Set;

/**
 * Controller for handling logout.
 * <p/>
 * Only logic for logout other than invalidating the session is remove the swfID from the list of recognized ones
 * for this session. If the count drops to 0, or the swfID is not supplied, then invalidate the session.
 */
public class LogoutController extends AbstractController implements InitializingBean {

    public static final String DEFAULT_VIEW_NAME = "logout";

    private String viewName = DEFAULT_VIEW_NAME;

	/**
     * Unit tests.
     */	
    public void afterPropertiesSet() throws Exception {
        Assert.notNull(viewName, "viewName must not be null");
    }

    /**
     * Initialize and set up the Main display parameters.
     * @param  request  The HTTP request.
	 * @param  response  The HTTP response.
	 * @return The modelAndView of the Main Board visualization.
     */
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String swfID = request.getParameter("swfID");
        if (!StringUtils.hasLength(swfID)) {
            request.getSession().invalidate();
        } else {
            String ids = (String) request.getSession().getAttribute(SessionConstants.RECOGNIZED_SWF_IDS_KEY);
            Set idSet = StringUtils.commaDelimitedListToSet(ids);
            if (idSet.isEmpty()) {
                request.getSession().invalidate();
            } else {
                idSet.remove(swfID);
                if (idSet.isEmpty()) {
                    request.getSession().setAttribute(SessionConstants.RECOGNIZED_SWF_IDS_KEY, null);
                    request.getSession().invalidate();
                } else {
                    ids = StringUtils.collectionToCommaDelimitedString(idSet);
                    request.getSession().setAttribute(SessionConstants.RECOGNIZED_SWF_IDS_KEY, ids);
                }
            }
        }

        return new ModelAndView(getViewName());
    }

   /**
     * Retrieve the current view name.
     * @return   The current view name.
     */
    public String getViewName() {
        return viewName;
    }

   /**
     * Set the current view name.
     * @param viewName  The current view name.
     */
    public void setViewName(String viewName) {
        this.viewName = viewName;
    }
}
