package gov.va.med.edp.web.controller;

import gov.va.med.edp.web.view.CsvView;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.support.WebContentGenerator;

/**
 * This controller handles request for exporting reports.
 */
public class ExportReportController extends TrackingController {
    private static final String CSV_VIEW = "csvView";

	/**
	  * Initialize the controller environment and set the Require Session flag.
      */
    public ExportReportController() {
        super();
        setSupportedMethods(new String[]{WebContentGenerator.METHOD_POST, WebContentGenerator.METHOD_GET});
    }    
    
    /**
     * Create ModelAndView for the Export report.
     * @param  result  The result of HTTP request processing.
	 * @return The modelAndView of the Export visualization.
     */
    protected ModelAndView createModelAndView(String result) {
        return new ModelAndView(CSV_VIEW, CsvView.CSV_MODEL, result);
    }
    
}
