package gov.va.med.edp.web.controller;

import java.util.Enumeration;
import java.util.Iterator;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import org.springframework.web.servlet.support.WebContentGenerator;

/**
 * This controller handles request for debugging.
 */
public class DebugController extends AbstractController implements InitializingBean {

    private static Logger log = Logger.getLogger(DebugController.class);

/**
 * Initialize the debug controller environment and set the appropriate supported web methods.
 */
    public DebugController() {
    	debug("->DebugController. afterPropertiesSet ");
    	setSupportedMethods(new String[]{WebContentGenerator.METHOD_POST});
    }

    /**
     * Initialize and set up the Debug display parameters.
     * @param  request  The HTTP request.
	 * @param  response  The HTTP response.
	 * @return The modelAndView of the Debug Board visualization.
     */    
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
    	debug("->handleRequestInternal (debug.html)");    		
        ModelAndView mav = new ModelAndView("debugView");
       return mav;    
    }

    private void debug(String s) {
    	if (log.isDebugEnabled()){
    		log.debug(s);
    	}
	}
	
    /**
     * Output debug information.
     */    	
	@Override
	public void afterPropertiesSet() throws Exception {

		debug("->DebugController. afterPropertiesSet ");   
	}

}
