package gov.va.med.edp.web.controller;

import gov.va.med.edp.vo.BigBoardDebugInfoVO;
import gov.va.med.edp.web.view.XmlView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.util.Enumeration;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.support.WebContentGenerator;
import java.util.HashMap;
import java.util.Map;
import gov.va.med.edp.enums.RPCParameterEnum;
import gov.va.med.edp.enums.CommandEnum;
import java.util.Collections;

/**
 * This controller handles request for the Big Board.
 */
public class BigDisplayBoardController extends SiteCodeController implements InitializingBean {

    private static final String MACHINE_NAME_PARAM = SiteCodeController.MACHINE_NAME_PARAM;
    public static final String MACHINE_NAME_HEADER = SiteCodeController.MACHINE_NAME_HEADER;

    protected static final String XML_VIEW = "xmlView";
    
    private static Logger log = Logger.getLogger(BigDisplayBoardController.class);
	
/**
 * Set the Web context support methods.
 */
    public BigDisplayBoardController() {
        //setRequireSession(false);
        setSupportedMethods(new String[]{WebContentGenerator.METHOD_POST, WebContentGenerator.METHOD_GET});
        debug("BigDisplayBoardController -> " + this.getSupportedMethods());
    }

    /**
     * Unit tests.
     */	
    public void afterPropertiesSet() throws Exception {
//    	Assert.notNull(getSiteCodeDao(), "siteCodeDao is required");
    	Assert.notNull(getTrackingDao(), "trackingDao is required");
    	Assert.notNull(getServerPackageVersionDao(), "ServerPackageVersionDao is required");
    	debug("BigDisplayBoardController->afterPropertiesSet");
    }

    /**
     * Initialize and set up the Big Board display parameters.
     * @param  request  The HTTP request.
	 * @param  response  The HTTP response.
	 * @return The modelAndView of the Big Board visualization.
     */
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
    	debug("\n\n->bigboard board.xml\n\n");
    	String siteCodeValue = request.getParameter(SITE_CODE_PARAM);    	
    	String boardValue = request.getParameter(BOARD_PARAM); 	
    	String areaNameValue = request.getParameter(AREA_NAME_PARAM);  	
    	String areaValue = request.getParameter(AREA_PARAM);   	
    	String lastValue = request.getParameter(LAST_PARAM);   	
    	String commandValue = request.getParameter(COMMAND_PARAM);
    	String isformValue = request.getParameter(IS_FORM_PARAM); 
    	String debugValue = request.getParameter(DEBUG_PARAM);

    	
    	debug("->bigboard board.xml (entry) sitecode : " + siteCodeValue 
				+ " , command : " + commandValue
				+ " , area : " + areaValue
				+ " , areaName : " + areaNameValue
				+ " , board : " + boardValue
				+ " , last : " + lastValue
				+ " , isform : " + isformValue
				+ " , debug : " + debugValue
				+ " , viewname : " + XML_VIEW);
    	
    	String result = "";
    	
    	Map<String, String> params = new HashMap<String, String>();
    	
    	// Get an existing session, set by the BigBoardClientVersionController
		HttpSession session = request.getSession(false);
	
		debugSessionAttributes(session);

		if (debugValue == null) { // not in request, get from session.
			debugValue = (String)session.getAttribute(SessionConstants.DEBUG);
			debug("->bigboard session debugOn : " + debugValue);
			setDebugOn(debugValue);
		} 
		 
		if (!StringUtils.hasText(siteCodeValue)) {
			siteCodeValue = (String)session.getAttribute(SessionConstants.SITE_CODE);
			debug("->bigboard session currentSiteCode : " + siteCodeValue);
		}
				
		
		/*
    	 * If debug parameters are supplied through a form and not the 
    	 * flash application use the parameters passed in.
    	 */
		if (!StringUtils.hasText(isformValue)) {
			
			params = buildParameterMap(request);
			debug("bigboard->  request before session attribute parameters:" + params.toString());
			
			/*
			 * If the area is null or empty, the area was stored in BigBoardClientVersionSynchronizationController when it was
			 * passed in via the URL bigboard.html?area=1
			 * 
			 * Otherwise it was requested view the EDIS main application as a parameter and should already be in the request.
			 * 
			 */
			if (!StringUtils.hasText(areaValue)) {
				areaValue = (String)session.getAttribute(SessionConstants.AREA);
				debug("->bigboard session currentArea : " + areaValue);
				
				addAreaToParamaters(params, areaValue);
				
			}
			/*
			 * If the area is null or empty, the area was stored in BigBoardClientVersionSynchronizationController when it was
			 * passed in via the URL bigboard.html?board=Main (default) 
			 * 
			 * Otherwise it was requested view the EDIS main application as a parameter and should already be in the request.
			 * Called via initDisplayBoard or refreshDisplayBoard.  The bigboard calls store in session while the application passes
			 * the data through  request.
			 * 
			 */
			if (!StringUtils.hasText(boardValue)) {
				
				boardValue = (String)session.getAttribute(SessionConstants.BOARD_NAME);
				debug("->bigboard session currentBoard : " + boardValue);				
				addBoardNameToParamaters(params, boardValue);
			}
			
		} else {
			params = createDebugParamsIfPresent(commandValue,areaValue,boardValue,lastValue);
			debug("bigboard->  debug parameters:" + params.toString());			
			/*
			 * This was already evaluated via BigBoardClientVersionSynchronizationController
			 * This is performed again for cases where the testing is used via a jsp form.
			 */		
			ModelAndView modelAndView = evaluateSiteCode(siteCodeValue);
	    	
	    	if(modelAndView != null) {
	    		return modelAndView;
	    	}
		}
		
		
		debug("bigboard-> before execute parameters:" + params.toString());
				
		
		if(isDebugOn()){
			debug("bigboard->  debug set :" + debugOn);
			if (isInitTrackingCommand(request)) {
				result = "<user area=\"1\" areaNm=\"Emergency Department\" version=\"3.0\" />";
			} else {
				result = ""; // TODO add mock for initDisplayBoard and refreshDisplayBoard.
			}
			
		} else {
			result = getTrackingDao().executeCommand(siteCodeValue, "0", params);
		}
		
		debug("bigboard-> result :" + result);
    	  	
        
        return createModelAndView(result);
        
        
       
    	
    /*	//First attempt is to get the machineName from HTTP Header:EdisClientMachineName as decided 
    	// this HTTP header is appended by the load balancer and the value of this header (the machine name)
    	//is parsed by the load balancer.
    	String machineName = parseCNFromHttpHeaders(request.getHeader(MACHINE_NAME_HEADER)); 
    	
    	if (StringUtils.hasText(machineName)){
			clearRequestAndSession(request);
    	} else {
    		machineName = getMachineNameFromUserPrincipalOrSessionOrRequest(request);
    	}
    	debug("Machine name obtained from certificate/HTTP Header/request/session:" + machineName);
    	String siteCode = getSiteCodeDao().getSiteCode(machineName);
    	
    	if (!StringUtils.hasText(siteCode)){
    		String errorMsg = "No site code was found for the machine name: " + machineName;
    		return createErrorModelAndView(errorMsg);
    	}    	

    	result = getTrackingDao().executeCommand(siteCode, "0", buildParameterMap(request,machineName));
    	if (isInitCommand(request))
    	result = appendSiteAndVistaLinkConnectionInfo(result, request, siteCode, machineName);    	
    	return createModelAndView(result, siteCode, machineName);*/
    }
    private boolean isInitTrackingCommand(HttpServletRequest request) {
		boolean success = false;
		if (request != null) {
			
			String command = request.getParameter(RPCParameterEnum.COMMAND.getParameterName());
			
			debug("bigboard->  isInitTrackingCommand command :" + command);
			if (command != null) {
				if(command.equals(CommandEnum.INIT_TRACKING.getCommandName())) {
					
					success = true;
				}
			}
		}
		debug("bigboard->  isInitTrackingCommand :" + success);
		return success;
	}
    private void debugSessionAttributes(HttpSession session) {
		@SuppressWarnings("rawtypes")
		Enumeration e = session.getAttributeNames();
		 
		while (e.hasMoreElements()) {
		    String name = (String) e.nextElement();
		    debug("->bigboard session attribure name : " + name + " , value : " + session.getAttribute(name));
		}
		
	}
	private void clearRequestAndSession(HttpServletRequest request) {
		request.getSession().setAttribute(MACHINE_NAME_PARAM, null);
		request.setAttribute(MACHINE_NAME_PARAM, null);
	}

	private boolean isInitCommand(HttpServletRequest request) {
		if (request.getParameter("command").equals("initDisplayBoard")) return true;
		return false;
	}	

    /**
     * Create ModelAndView for the Big Board.
     * @param  result  The result of HTTP request processing.
	 * @return The modelAndView of the Big Board visualization.
     */
    protected ModelAndView createModelAndView(String result) {
    	return new ModelAndView(XML_VIEW, XmlView.XML_FRAGMENT, result);
    }

    private String appendSiteAndVistaLinkConnectionInfo(String result,HttpServletRequest request, String siteCode, String machineName) {
    	BigBoardDebugInfoVO vistalinkInfo = serverPackageVersionDao.getVistaLinkConnectionInfo(siteCode);
    	vistalinkInfo.setSiteId(siteCode);
    	vistalinkInfo.setMachineName(machineName);
    	result = result.concat(vistalinkInfo.toString());
    	return result;
    }
    
    private void addBoardNameToParamaters(Map<String, String> params, String boardName) {
    	if (StringUtils.hasText(boardName)) {
			params.put(RPCParameterEnum.BOARD_NAME.getParameterName(), boardName);
		}
    }
    
    private void addAreaToParamaters(Map<String, String> params, String areaId) {
    	if (StringUtils.hasText(areaId)) {
			params.put(RPCParameterEnum.AREA_ID.getParameterName(), areaId);
		}
    }
    
    private void addCommandToParamaters(Map<String, String> params, String commandName) {
    	if (StringUtils.hasText(commandName)) {
			params.put(RPCParameterEnum.COMMAND.getParameterName(), commandName);
		}
    }
    
    private void addLastUpdatedToParamaters(Map<String, String> params, String lastUpdated) {
    	if (StringUtils.hasText(lastUpdated)) {
			params.put(RPCParameterEnum.LAST_UPDATED.getParameterName(), lastUpdated);
		}
    }

    private Map<String, String> createDebugParamsIfPresent(String command,
			String area, String board, String last) {

		Map<String, String> params;

		if (StringUtils.hasText(command)) {

			params = new HashMap<String, String>();
			//params.put(RPCParameterEnum.COMMAND.getParameterName(), command);

			addCommandToParamaters(params,command);
			
		} else { // Must at least have a command

			params = Collections.<String, String> emptyMap();
			return params;

		}

		addAreaToParamaters(params,area);
		addBoardNameToParamaters(params,board);
		addLastUpdatedToParamaters(params,last);

		return params;
	}
	private void debug(String s) {
    	if (log.isDebugEnabled()){
    		log.debug(s);
    	}
	}    


}
