package gov.va.med.edp.web.controller;


import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.log4j.Logger;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.ModelAndView;
import gov.va.med.edp.vo.BigBoardSessionInfoVO;

/**
 * This controller handles request for the Big Board.
 */
public class BigBoardClientVersionSynchronizationController extends ClientVersionSynchronizationController {


	private String errorMsg;

    private static Logger logger = Logger.getLogger(BigBoardClientVersionSynchronizationController.class);

    /**
     * Set the Require Session flag.
     */	
    public void afterPropertiesSet() throws Exception {
    	setRequireSession(false);
        super.afterPropertiesSet();
        Assert.notNull(serverPackageVersionDao, "serverPackageVersionDao must not be null");
//    	Assert.notNull(getSiteCodeDao(), "siteCodeDao is required");
    	Assert.notNull(getTrackingDao(), "trackingDao is required");
    	
    }

    /**
     * Initialize and set up the Big Board display parameters.
     * @param  request  The HTTP request.
	 * @param  response  The HTTP response.
	 * @return The modelAndView of the Big Board visualization.
     */
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
    	   	   	    	
    	String siteCodeRequestValue = request.getParameter(SITE_CODE_PARAM);
    	
    	String boardRequestValue = request.getParameter(BOARD_PARAM);
    	
    	String areaNameRequestValue = request.getParameter(AREA_NAME_PARAM);
    	
    	String areaRequestValue = request.getParameter(AREA_PARAM);
    	
    	String debugRequestValue = request.getParameter(DEBUG_PARAM);
    	
    	setDebugOn(debugRequestValue);	
    	
    	debug("->handleRequestInternal (bigboard.html) siteCode : " + siteCodeRequestValue 
				+ " , areaName : " + areaNameRequestValue 
				+ " , area : " + areaRequestValue 
				+ " , board : " + boardRequestValue 
				+ " , debug : " + debugRequestValue
				+ " , viewname : " + getViewName());
    	
    	
    /*	String resultView = evaluateSiteCode(siteCodeRequestValue);
		
		if(resultView != SiteCodeController.VALID_SITECODE) {
			return resultView;
		}*/
		
    	ModelAndView modelAndView = evaluateSiteCode(siteCodeRequestValue);
    	
    	if(modelAndView != null) {
    		return modelAndView;
    	}
    	
    	
    	
    	debug("->handleRequestInternal debugRequestValue : " + debugRequestValue 
				+ " , isDebugOn() : " + isDebugOn() 
				+ " , this.debugOn : " + this.debugOn);
    	
/*    	//set the machine name in an existing session for refreshes/restored sessions
		HttpSession session = request.getSession(false);
		if (session != null){
		session.setAttribute(MACHINE_NAME_PARAM, machineName);
		} else {
    		return createErrorModelAndView("Invalid Session was detected. Please try re-launching the EDIS Big Board");
		}
    	
    	String siteCode = getSiteCodeDao().getSiteCode(machineName);
		debug("Site Code Obtained for Machine: " + machineName + " was: " + siteCode);

    	if (!StringUtils.hasText(siteCode)){
    		errorMsg = "A matching site code for the machine: " + machineName + " was not found in the EDP.SiteMapper table.\n" +
    						"Please contact the EDIS national help desk with this message for remedy.";
    		return createErrorModelAndView(errorMsg);
    	}    	*/
		
	/*	String serverPackageVersion = (String) request.getSession().getAttribute(SessionConstants.SERVER_PACKAGE_VERSION_KEY);
    	if (serverPackageVersion == null) {
        	serverPackageVersion = serverPackageVersionDao.getServerPackageVersion(siteCode);
            request.getSession().setAttribute(SessionConstants.SERVER_PACKAGE_VERSION_KEY, serverPackageVersion);
        }
		debug("serverPackageVersion is: " + serverPackageVersion);

    	if (isBoardNameAvailableForMachine(siteCode, machineName, request)) return super.handleRequestInternal(request, response);*/
		
		BigBoardSessionInfoVO bigBoardSessionInfoVO;

		if(isDebugOn()) {
			bigBoardSessionInfoVO = new BigBoardSessionInfoVO();
			bigBoardSessionInfoVO.setArea("1");
			bigBoardSessionInfoVO.setAreaName("EDIS Apllication");//Not used
			bigBoardSessionInfoVO.setBoardName("Main (default)");
			bigBoardSessionInfoVO.setServerPackageVersion("3.0"); //Not used
			bigBoardSessionInfoVO.setSiteId(siteCodeRequestValue);
			//"<user area=\"1\" areaNm=\"Emergency Department\" version=\"3.0\" />";
		} else {
			bigBoardSessionInfoVO = serverPackageVersionDao.getBigBoardSessionInfo(siteCodeRequestValue,
					boardRequestValue);
		}
    	
		if(bigBoardSessionInfoVO == null){
			errorMsg = "The bigBoardSessionInfoVO is null, please launch bigboard again.";
    		debug("->bigboard error " + errorMsg + " , errorViewName : " + getErrorViewName());
    		return createErrorModelAndView(errorMsg);
		}
		
		HttpSession session = request.getSession(false);
		// No session exists, create one
		if(session == null) {
			session = request.getSession();
			debug("->bigboard create new session");
		}
		
		setSessionAttributes(session,
				isDebugOn(),
				bigBoardSessionInfoVO.getSiteId(),
				bigBoardSessionInfoVO.getServerPackageVersion(),
				bigBoardSessionInfoVO.getBoardName(),
				bigBoardSessionInfoVO.getArea());
		
		
    	/*debug("->bigboard serverPackageVersion : " + serverPackageVersion);*/
    	
    	/*session.setAttribute(SessionConstants.BOARD_NAME, bigBoardSessionInfoVO.getBoardName());*/
    	
    	/*session.setAttribute(SessionConstants.AREA, bigBoardSessionInfoVO.getArea());*/
        
        return super.handleRequestInternal(request, response);
    }

    private void setSessionAttributes(HttpSession session,
			Boolean debug,
			String sitecode,
			String serverPackageVersion,
			String boardName,
			String area) {
		
		if (debug != null && debug) { // Only set if true
			session.setAttribute(SessionConstants.DEBUG, debug.toString());
		}
		
		if (sitecode != null) { // Always set, validated prior to this call
			session.setAttribute(SessionConstants.SITE_CODE, sitecode);
		}
		
		if (serverPackageVersion != null) {
        	session.setAttribute(SessionConstants.SERVER_PACKAGE_VERSION_KEY, serverPackageVersion);
        }
		
		if (boardName != null) {
			session.setAttribute(SessionConstants.BOARD_NAME, boardName);
        }
		
		if (area != null) {
			session.setAttribute(SessionConstants.AREA, area);
        }
	
		debug("->bigboard setSessionAttributes(" +
				"debug : " + debug + 
				" , siteCode : " + sitecode + 
				" , serverPackageVersion : " + serverPackageVersion + 
				" , boardName : " + boardName +
				" , area : " + area);	
	}
    
	/*private boolean isBoardNameAvailableForMachine(String siteCode, String machineName, HttpServletRequest request) {
		String result = getTrackingDao().executeCommand(siteCode, "0", buildParameterMap(request,machineName));
    	if (result.startsWith("<error>")){
    		int start = result.indexOf("<error>");
    		int end = result.indexOf("</error>");
    		errorMsg = result.substring(start + 7, end);
    		debug("isBoardNameAvailableForMachine: false");
    		return false;
    	} 
    	debug("isBoardNameAvailableForMachine: true");
    	return true;
	}*/

    private void debug(String s) {
    	if (logger.isDebugEnabled()){
    		logger.debug(s);
    	}
	}

}
