package gov.va.med.edp.vo;

/**
 * Contains information pertaining to session.
 * @author useruseruser12
 *
 */
public class SessionVO {

    static final int DEFAULT_TIMEOUT_MS = 300000;   // 5 minutes
    static final int DEFAULT_COUNTDOWN_MS = 10000;  // 10 seconds

    private String serverPackageVersion;
    private int timeOutMillis = DEFAULT_TIMEOUT_MS;
    private int countDownMillis = DEFAULT_COUNTDOWN_MS;

    /**
     * Get the server package version.
     * @return the server package version.
     */
    public String getServerPackageVersion() {
        return serverPackageVersion;
    }

    /**
     * Set the server package version.
     * @param serverPackageVersion The server package version.
     */
    public void setServerPackageVersion(String serverPackageVersion) {
        this.serverPackageVersion = serverPackageVersion;
    }

    /**
     * Get the time out  in milliseconds.
     * @return the time out  in milliseconds.
     */
    public int getTimeOutMillis() {
        return timeOutMillis;
    }

    /**
     * Set the time out  in milliseconds.
     * @param timeOutMillis The time out in milliseconds.
     */
    public void setTimeOutMillis(int timeOutMillis) {
        this.timeOutMillis = timeOutMillis;
    }

    /**
     * Get the count down in milliseconds.
     * @return the count down in milliseconds.
     */
    public int getCountDownMillis() {
        return countDownMillis;
    }

    /**
     * Set the count down in milliseconds.
     * @param countDownMillis The count down in milliseconds.
     */
    public void setCountDownMillis(int countDownMillis) {
        this.countDownMillis = countDownMillis;
    }

    /**
     * Calculates the time, in seconds, between client requests before the servlet container will invalidate this session.
     *
     * @return The max inactive interval (getTimeOutMillis() + getCountDownMillis()) / 1000 + 60)
     */
    public int getMaxInactiveInterval() {
        return (getTimeOutMillis() + getCountDownMillis()) / 1000 + 60;
    }

	/**
	 *  Return info about the current environment.
	 * @return  String of the current environment.
	 */
    public String toString() {
        return "SessionVO{" +
                "serverPackageVersion='" + serverPackageVersion + '\'' +
                ", timeOutMillis=" + timeOutMillis +
                ", countDownMillis=" + countDownMillis +
                '}';
    }
}
