package gov.va.med.edp.vo;


import java.lang.Integer;

/**
 * Contains information pertaining to bigboard setup information.
 * 
 * @author useruseruser12
 *
 */
public class BigBoardSessionInfoVO {

	/**
	 * Undefined version data.
	 */
	public static final String DEFAULT_VERSION = "(Undefined)";  // 10 seconds	
	private String boardName;
	private String siteId;
	private String area;
	private String areaName;
	private String serverPackageVersion = DEFAULT_VERSION;
	
	//"<user area=\"1\" areaNm=\"Emergency Department\" version=\"3.0\" />";

	/**
	 * Constructor.
	 */
	public BigBoardSessionInfoVO() {
		super();
	}
	
	/**
	 * Get the board name.
	 * @return The board name.
	 */
	public String getBoardName() {
		return boardName;
	}

	/**
	 * Set the  board name.
	 * @param boardName The  board name.
	 */
	public void setBoardName(String boardName) {
		this.boardName = boardName;
	}
	
	/**
	 * Get the site id.
	 * @return The site id.
	 */
	public String getSiteId() {
		return siteId;
	}

	/**
	 * Set the site id.
	 * @param siteId The site id.
	 */
	public void setSiteId(String siteId) {
		this.siteId = siteId;
	}

	/**
	 * Get the area name.
	 * @return the area name.
	 */
	public String getAreaName() {
		return areaName;
	}

	/**
	 * Set the area name.
	 * @param areaName The area name.
	 */
	public void setAreaName(String areaName) {
		this.areaName = areaName;
	}
	
	
	/**
	 * Get the area id.
	 * @return the area id.
	 */
	public String getArea() {
		return area;
	}

	/**
	 * Set the area id.
	 * @param area The area id.
	 */
	public void setArea(String area) {
		this.area = area;
	}
	
	/**
     * Get the server package version.
     * @return the server package version.
     */
    public String getServerPackageVersion() {
        return serverPackageVersion;
    }

    /**
     * Set the server package version.
     * @param serverPackageVersion The server package version.
     */
    public void setServerPackageVersion(String serverPackageVersion) {
        this.serverPackageVersion = serverPackageVersion;
    }

	/**
	 *  Return info about the current environment.
	 * @return  String of the current environment.
	 */
    public String toString() {
        return "BigBoardSessionInfoVO { " +
                "serverPackageVersion = " + serverPackageVersion + 
                ", boardName = " + boardName + 
                ", area = " + area + 
                ", areaName = " + areaName + 
                ", siteId = " + siteId + 
                " }";
    }
}
