package gov.va.med.edp.vo;
/**
 * Contains information pertaining to vista link and local machine/site id data.
 *
 */
public class BigBoardDebugInfoVO {

	private String vistalinkIPAddress;
    private String vistalinkPort;
    private String siteId;
    private String machineName;	
	/**
	 * Constructor.
	 * @param vistalinkIPAddress
	 * @param vistalinkPort
	 */
	public BigBoardDebugInfoVO(String vistalinkIPAddress, String vistalinkPort) {
		super();
		this.vistalinkIPAddress = vistalinkIPAddress;
		this.vistalinkPort = vistalinkPort;
	}
	/**
	 * Constructor.
	 */   
	public BigBoardDebugInfoVO() {
		super();
	}
	/**
	 * Get the vista link address.
	 * @return the vista link address.
	 */    
    public String getVistalinkIPAddress() {
		return vistalinkIPAddress;
	}
	/**
	 * Set the vista link address.
	 * @param vistalinkIPAddress The vista link address.
	 */
	public void setVistalinkIPAddress(String vistalinkIPAddress) {
		this.vistalinkIPAddress = vistalinkIPAddress;
	}
	/**
	 * Get the vista link port.
	 * @return the vista link port.
	 */
	public String getVistalinkPort() {
		return vistalinkPort;
	}
	/**
	 * Set the vista link port.
	 * @param vistalinkPort The vista link port.
	 */
	public void setVistalinkPort(String vistalinkPort) {
		this.vistalinkPort = vistalinkPort;
	}
	/**
	 * Get the site id.
	 * @return The site id.
	 */
	public String getSiteId() {
		return siteId;
	}
	/**
	 * Set the site id.
	 * @param siteId The site id.
	 */
	public void setSiteId(String siteId) {
		this.siteId = siteId;
	}
	/**
	 * Get the machine name.
	 * @return the machine name.
	 */
	public String getMachineName() {
		return machineName;
	}
	/**
	 * Set the machine name.
	 * @param machineName The machine name.
	 */
	public void setMachineName(String machineName) {
		this.machineName = machineName;
	}

	/**
	 * Get the string representation of this class.
	 * @return the string.
	 */
    public String toString() {
        return "<vistalinkConnectionInfo><vistalinkIPAddress>" + vistalinkIPAddress + "</vistalinkIPAddress>" +
                "<vistalinkPort>" + vistalinkPort + "</vistalinkPort>" +
                "<siteId>" + siteId + "</siteId>" +
                "<machineName>" + machineName + "</machineName>" +
                "</vistalinkConnectionInfo>";
    }
}
