package gov.va.med.edp.rpc;

import org.springframework.dao.InvalidDataAccessApiUsageException;
import gov.va.med.vistalink.adapter.record.VistaLinkFaultException;

/**
 * Exception thrown when the vista link API is incorrectly used.
 */
public class VistaLinkRpcInvalidApiUsageException extends InvalidDataAccessApiUsageException {

    private VistaLinkFaultException fault;
    /**
     * Constructor.
     * @param fault The exception to throw.
     */
    public VistaLinkRpcInvalidApiUsageException(VistaLinkFaultException fault) {
        super(fault.getMessage());
        this.fault = fault;
    }
    /**
    * Retrieve the error code.
    * @return the error code.
    */
   public String getErrorCode() {
       return fault.getErrorCode();
   }
   /**
    * Retrieve the error message.
    * @return the error message.
    */
   public String getErrorMessage() {
       return fault.getErrorMessage();
   }
   /**
    * Retrieve the error type.
    * @return the error type.
    */
   public String getErrorType() {
       return fault.getErrorType();
   }
   /**
    * Retrieve the error fault actor.
    * @return the error fault actor.
    */
   public String getFaultActor() {
       return fault.getFaultActor();
   }
   /**
    * Retrieve the error fault code.
    * @return the error fault code.
    */
   public String getFaultCode() {
       return fault.getFaultCode();
   }
   /**
    * Retrieve the error fault string.
    * @return the error fault string.
    */
   public String getFaultString() {
       return fault.getFaultString();
   }
}
