package gov.va.med.edp.rpc;

import org.springframework.dao.support.DaoSupport;

/**
 * Vista Link class for DAOs, implements template methods for DAO initialization. 
 */
public class VistaLinkDaoSupport extends DaoSupport {

    private VistaLinkRpcTemplate rpcTemplate;
    
	/* (non-Javadoc)
	 * @see org.springframework.dao.support.DaoSupport#checkDaoConfig()
	 */
	 /**
	  * Initialize the connection factory 
	  */
    protected void checkDaoConfig() throws IllegalArgumentException {
        if (this.rpcTemplate == null) {
			setConnectionFactoryLocator(new InstitutionMappingConnectionFactoryLocator());
		}
    }
	/**
	 * Creates a vista link remote procedure call template.
	 * @param connectionFactoryLocator Locator factory.
	 * @return the VistaLinkRpcTemplate.
	 */
    protected VistaLinkRpcTemplate createRpcTemplate(ConnectionFactoryLocator connectionFactoryLocator) {
        return new VistaLinkRpcTemplate(connectionFactoryLocator);
    }
	/**
	 * Retrieve the connector factory locator.
	 * @return the ConnectionFactoryLocator.
	 */
    public ConnectionFactoryLocator getConnectionFactoryLocator() {
        return rpcTemplate.getConnectionFactoryLocator();
    }
	/**
	 * Set the connector factory locator.
	 * @param connectionFactoryLocator The connector factory locator.
	 */
    public void setConnectionFactoryLocator(ConnectionFactoryLocator connectionFactoryLocator) {
        setRpcTemplate(createRpcTemplate(connectionFactoryLocator));
    }
	/**
	 * Retrieve the RpcTemplate.
	 * @return The RpcTemplate.
	 */
    public VistaLinkRpcTemplate getRpcTemplate() {
        return rpcTemplate;
    }
	/**
	 * Set the RpcTemplate.
	 * @param rpcTemplate The RpcTemplate.
	 */
    public void setRpcTemplate(VistaLinkRpcTemplate rpcTemplate) {
        this.rpcTemplate = rpcTemplate;
    }
}
