package gov.va.med.edp.rpc;

import gov.va.med.vistalink.adapter.cci.VistaLinkConnectionFactory;
import gov.va.med.vistalink.institution.InstitutionMapNotInitializedException;
import gov.va.med.vistalink.institution.InstitutionMappingDelegate;
import gov.va.med.vistalink.institution.InstitutionMappingNotFoundException;
import org.springframework.dao.DataAccessResourceFailureException;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.cci.ConnectionFactory;
import java.text.MessageFormat;

import org.apache.log4j.Logger;

/**
 * Implementation to retrieve JCA connection factories for a particular VistA station number.
 */
public class InstitutionMappingConnectionFactoryLocator implements ConnectionFactoryLocator {
    
	private static final String NO_CONNECTION_FACTORY = "Unable to obtain connection factory for station ''{0}''";
    private static final String NO_CONNECTION_FACTORY_JNDI = "Unable to obtain connection factory for station ''{0}'' at JNDI name ''{1}''";
    private static Logger log = Logger.getLogger(InstitutionMappingConnectionFactoryLocator.class);
    
    public ConnectionFactory getConnectionFactory(String stationNumber) throws DataAccessResourceFailureException {
        
    	debug("->getConnectionFactory(stationNumber = " + stationNumber  + ")");
    	
    	try {
            String jndiConnectorName = InstitutionMappingDelegate.getJndiConnectorNameForInstitution(
                    stationNumber);
            
            debug("->getConnectionFactory jndiConnectorName = " + jndiConnectorName);
            
            try {
                Context ic = new InitialContext();
                VistaLinkConnectionFactory vistaLinkConnectionFactory = (VistaLinkConnectionFactory) ic.lookup(jndiConnectorName);
                ic.close();
                if (vistaLinkConnectionFactory == null)
                    throw new DataAccessResourceFailureException(MessageFormat.format(NO_CONNECTION_FACTORY_JNDI, new Object[]{stationNumber, jndiConnectorName}));
                return vistaLinkConnectionFactory;
            } catch (NamingException e) {
                throw new DataAccessResourceFailureException(MessageFormat.format(NO_CONNECTION_FACTORY_JNDI, new Object[]{stationNumber, jndiConnectorName}), e);
            }
        } catch (InstitutionMappingNotFoundException e) {
            throw new DataAccessResourceFailureException(MessageFormat.format(NO_CONNECTION_FACTORY, new Object[]{stationNumber}), e);
        } catch (InstitutionMapNotInitializedException e) {
            throw new DataAccessResourceFailureException(MessageFormat.format(NO_CONNECTION_FACTORY, new Object[]{stationNumber}), e);
        }

    }
    
    private void debug(String s) {
    	if (log.isDebugEnabled()){
    		log.debug(s);
    	}
	} 
}
