package gov.va.med.edp.enums;

/**
 * 
 * This enumeration holds all parameters needed for RPC calls.
 * 
 * @author useruseruser12
 *
 */
public enum RPCParameterEnum {
	
	BOARD_NAME("board"),
	AREA_ID("area"),
	LAST_UPDATED("last"),
    COMMAND("command");
	
	private String parameterName;
	 
	private RPCParameterEnum(String pName) {
		parameterName = pName;
	}
	 
	/**
	 * Get the parameter name.
	 * @return String parameter name.
	 */
	public String getParameterName() {
	  return parameterName;
	}

	/* (non-Javadoc)
	 * @see java.lang.Enum#toString()
	 */
	/**
	 *  Retrieve the parameter name.
	 * @return The parameter name.
	 */
	@Override
	public String toString() {
		return getParameterName();
	}

}
