/**
 * 
 */
package gov.va.med.edp.enums;

/**
 * 
 * This enumeration holds all command strings.
 * 
 * @author useruseruser12
 *
 */
public enum CommandEnum {
	
	INIT_USER("initUser"),
	INIT_DISPLAY_BOARD("initDisplayBoard"),
	REFRESH_DISPLAY_BOARD("refreshDisplayBoard"),
    INIT_TRACKING("initTracking"),
    SAVE_WORKSHEET_CONFIG("saveWorksheetConfig"),
    EXECUTE_REPORT("executeReport"),
    SAVE_REPORT_DEF("saveReportDef"),
    GET_LEXICON_MATCHES("getLexiconMatches");
	
	private String commandName;
	 
	private CommandEnum(String command) {
		commandName = command;
	}
	 
	/**
	 * Get the command name.
	 * @return String command name.
	 */
	public String getCommandName() {
	  return commandName;
	}

	/* (non-Javadoc)
	 * @see java.lang.Enum#toString()
	 */
	/**
	 *  Retrieve the command name.
	 * @return The command name.
	 */
	@Override
	public String toString() {
		return getCommandName();
	}

}
