package gov.va.med.edp.dao.rpc;

import org.springframework.dao.DataAccessException;

import java.util.List;
import java.util.Map;
import java.util.ArrayList;
import gov.va.med.edp.dao.TrackingDao;
import gov.va.med.edp.rpc.VistaLinkDaoSupport;
import org.apache.log4j.Logger;

/**
 * Data Access Interface for executing tracking commands within Vista.
 *
 */
public class VistaLinkTrackingDao extends VistaLinkDaoSupport implements TrackingDao {
    
	static final String EDPF_TRACKING_SYSTEM_CONTEXT = "EDPF TRACKING SYSTEM";
    static final String EDP_CONTROLLER_RPC = "EDPCTRL RPC";
    private static Logger log = Logger.getLogger(VistaLinkTrackingDao.class);

    /**
     * Commands executed by this data access object are always executed by the "application user" against the stationNumber
     * set by the property on this bean.
     *
     * @param stationNumber The station number that this command is being executed on behalf of. Note how this is different
     *                      from the station number of the vista account this dao is communicating with.  Cannot be null.
     * @param duz           A duz to execute the command on behalf of. Can be null for some operations. Note how this is different
     *                      from the "application user duz" that RPCs are executed with.
     * @param params        A map containing key value pairs that are passed to the RPC as a multiple.
     * @return result of executing command RPC as a string.
     * @throws org.springframework.dao.DataAccessException
     *
     */
    public String executeCommand(String stationNumber, String duz, Map params) throws DataAccessException {
    	
    	debug("executeCommand(stationNumber = " + stationNumber 
    			+ ", duz = " + duz + ", params = " + params + ")");
    	
       // return getRpcTemplate().rpcAsUser(stationNumber, duz, EDPF_TRACKING_SYSTEM_CONTEXT, EDP_CONTROLLER_RPC, buildRpcParameterList(params));
        return getRpcTemplate().rpcAsUser(stationNumber, duz, EDPF_TRACKING_SYSTEM_CONTEXT, getRpcName(params), buildRpcParameterList(params));
    }

    private List buildRpcParameterList(Map params) {
        ArrayList paramList = new ArrayList();
        
        if (params.containsValue("saveWorksheetConfig")) {
        	paramList.add("WORKSHEET");
        }
		
		if (params.containsValue("executeReport")) {
        	paramList.add("ADHOC");
        }
		
		if (params.containsValue("saveReportDef")) {
        	paramList.add("ADHOC");
        }
		
        paramList.add(params);
        
        debug("buildRpcParameterList paramList = " + paramList);
        
        return paramList;
    }
    
    private String getRpcName(Map params) {
    	
    	String rpcName;
    	String rpcTypeKey = "edp";
    	
    	if(params == null) {
    		
    		rpcName = EDP_CONTROLLER_RPC;
    		
    	} else {
    		
    		Object value = params.get(rpcTypeKey);
    		
    		if (value != null) {
    			rpcName = (String)value;
    		} else {
    			rpcName = EDP_CONTROLLER_RPC;
    		}
    		
    	}
    	
		return rpcName;
	} 
 
	/**
	 *  Close the vistalink connector upon releasing resources.
	 *
	 */ 
    public void close() throws Exception {
    	  System.out.println("VistaLinkTrackingDAO is closed.");
    	  debug("->close()");
    }
    
    private void debug(String s) {
    	if (log.isDebugEnabled()){
    		log.debug(s);
    	}
	} 
}
