package gov.va.med.edp.dao.rpc;

import gov.va.med.edp.dao.SessionDao;
import gov.va.med.edp.vo.SessionVO;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.apache.log4j.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;

/**
 * Data Access Object used to retrieve session related information.
 *
 */
public class VistaLinkSessionDao extends VistaLinkTrackingDao implements SessionDao {
   
	private static final String UNABLE_TO_GET_USER_INFO = "unable to get user info";
    private static Logger log = Logger.getLogger(VistaLinkSessionDao.class);

	/* (non-Javadoc)
	 * @see gov.va.med.edp.dao.SessionDao#getSessionInfo(java.lang.String, java.lang.String)
	 */
    public SessionVO getSessionInfo(String stationNumber, String duz) throws DataAccessException {
        
    	Map params = new HashMap();
        params.put("command", "initUser");
        
        debug("getSessionInfo(stationNumber = " + stationNumber 
    			+ ", params = " + params + ")");
        
        String result = executeCommand(stationNumber, duz, params);
        
        debug("getSessionInfo result = "  + result);
        
        return createSessionInfo(result);
    }

    private SessionVO createSessionInfo(String result) {
    	debug("createSessionInfo(result = "  + result);
    	
    	Document doc = buildDocument(result);

        SessionVO session = new SessionVO();
        session.setServerPackageVersion(getServerPackageVersion(doc));
        session.setTimeOutMillis(Integer.parseInt(getTimeout(doc)));
        session.setCountDownMillis(Integer.parseInt(getCountdown(doc)));
        
        debug("createSessionInfo session = "  + session);
        
        return session;
    }

    private String getServerPackageVersion(Document doc) {
        return getUserElement(doc).getAttribute("version");
    }

    private String getTimeout(Document doc) {
        return getUserElement(doc).getAttribute("timeOut");
    }

    private Element getUserElement(Document doc) {
        return ((Element) doc.getDocumentElement().getElementsByTagName("user").item(0));
    }

    private String getCountdown(Document doc) {
        return getUserElement(doc).getAttribute("countDown");
    }

    private Document buildDocument(String result) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            return builder.parse(new InputSource(new StringReader("<results>" + result + "</results>")));
        } catch (ParserConfigurationException e) {
            throw new DataRetrievalFailureException(UNABLE_TO_GET_USER_INFO, e);
        } catch (IOException e) {
            throw new DataRetrievalFailureException(UNABLE_TO_GET_USER_INFO, e);
        } catch (SAXException e) {
            throw new DataRetrievalFailureException(UNABLE_TO_GET_USER_INFO, e);
        }
    }

	/**
	 *  Close the vistalink connector upon releasing resources.
	 *
	 */
    public void close() throws Exception {
    	System.out.println("VistaLinkSessionDAO is closed.");
  	  	debug("->close()");
  	}
    
    private void debug(String s) {
		if (log.isDebugEnabled()) {
			log.debug(s);
		}
	}
    
}
