package gov.va.med.edp.dao.rpc;

import gov.va.med.edp.rpc.VistaLinkDaoSupport;
import gov.va.med.edp.vo.BigBoardDebugInfoVO;
import gov.va.med.edp.dao.ServerPackageVersionDao;
import gov.va.med.edp.vo.BigBoardSessionInfoVO;
import org.apache.log4j.Logger;
import java.util.Map;
import java.util.HashMap;
import java.io.StringReader;
import java.io.IOException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

/**
 * Data Access Interface for retrieving information through commands within
 * Vista.
 */
public class VistaLinkServerPackageVersionDao extends VistaLinkBigBoardDao implements ServerPackageVersionDao {
    
	private static final String UNABLE_TO_GET_VERSION_INFO = "unable to get version info";    
	
    private static Logger log = Logger
			.getLogger(VistaLinkServerPackageVersionDao.class);
    
	/** Retrieve server Package version.
	 * 
     * @param stationNumber The station number that this command is being executed on behalf of. Note how this is different
     *                      from the station number of the vista account this dao is communicating with.  Cannot be null.
	 * @return			Server package version number.
	 */
    public String getServerPackageVersion(String stationNumber) {
        Map params = new HashMap();
        params.put("command", "initTracking");
        
        debug("getServerPackageVersion(stationNumber = " + stationNumber 
    			+ ")");
        
        String result = executeCommand(stationNumber, null, params);
        
        debug("getServerPackageVersion result = "  + result);
        
        return getVersion(result);
    }

	/* (non-Javadoc)
	 * @see gov.va.med.edp.dao.ServerPackageVersionDao#getBigBoardSessionInfo(java.lang.String, java.lang.String)
	 */
	public BigBoardSessionInfoVO getBigBoardSessionInfo(String stationNumber,
			String boardName) {
		
		BigBoardSessionInfoVO bigBoardSessionInfoVO = new BigBoardSessionInfoVO();
		
		Map<String, String> params = new HashMap<String, String>();
		
		params.put("command", "initTracking");
		
		debug("getBigBoardSessionInfo(stationNumber = " + stationNumber + ")");
		
		String result = executeCommand(stationNumber, null, params);
		
		debug("getBigBoardSessionInfo result = "  + result);
		
		Document doc = buildDocument(result);
		
		Element user = getUserElement(doc);
		
		debug("getBigBoardSessionInfo user element = "  + user.toString());
		
		bigBoardSessionInfoVO.setServerPackageVersion(user.getAttribute("version"));
		bigBoardSessionInfoVO.setArea(user.getAttribute("area"));
		bigBoardSessionInfoVO.setAreaName(user.getAttribute("areaNm"));
		bigBoardSessionInfoVO.setSiteId(stationNumber);
		bigBoardSessionInfoVO.setBoardName(boardName);
		
		debug("getBigBoardSessionInfo bigBoardSessionInfoVO = "  + bigBoardSessionInfoVO.toString());
		
		return bigBoardSessionInfoVO;
	}
    
	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * gov.va.med.edp.dao.ServerPackageVersionDao#getVistaLinkConnectionInfo
	 * (java.lang.String)
	 */
	public BigBoardDebugInfoVO getVistaLinkConnectionInfo(String stationNumber)
			throws DataAccessException {
		return getRpcTemplate().getVistaLinkConnectionInfo(stationNumber,
				EDPTRACKING_APPLICATION_USER);
	}   
    
    private String getVersion(String result) {
        Document doc = buildDocument(result);
        return getVersion(doc);
    }   
    
    private Element getUserElement(Document doc) {
        return (Element) doc.getDocumentElement().getElementsByTagName("user").item(0);
    }

    private String getVersion(Document doc) {
        Element user = getUserElement(doc);
        if (user == null) return null;
        return user.getAttribute("version");
    }

    private Document buildDocument(String result) {
           try {
               DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
               return builder.parse(new InputSource(new StringReader("<results>" + result + "</results>")));
           } catch (ParserConfigurationException e) {
               throw new DataRetrievalFailureException(UNABLE_TO_GET_VERSION_INFO, e);
           } catch (IOException e) {
               throw new DataRetrievalFailureException(UNABLE_TO_GET_VERSION_INFO, e);
           } catch (SAXException e) {
               throw new DataRetrievalFailureException(UNABLE_TO_GET_VERSION_INFO, e);
           }
       }
    
	/**
	 *  Close the vistalink connector upon releasing resources.
	 *
	 */
    public void close() throws Exception {
    	System.out.println("VistaLinkServerPackageVersionDAO is closed.");
    	debug("->close()");
    }
    
    private void debug(String s) {
		if (log.isDebugEnabled()) {
			log.debug(s);
		}
	}
}
