package gov.va.med.edp.dao;

import org.springframework.dao.DataAccessException;

import java.util.Map;
/**
 * Data Access Interface for executing tracking commands within Vista.
 *
 */
public interface TrackingDao {
    /**
     * Execute a remote procedure call.
     * 
     * @param stationNumber This division number.
     * @param duz The user duz.
     * @param params The map of values.
     * @return The return data as xml.
     * @throws DataAccessException
     */
    String executeCommand(String stationNumber, String duz, Map params) throws DataAccessException;
}
