package gov.va.med.edp.dao;

import org.springframework.dao.DataAccessException;
/**
 * Data Access Interface for retrieving site/division information through commands within Vista.
 *
 */
public interface SiteCodeLookUpDao {
    /**
     * Retrieve the site code associated with the machine name supplied.
     * 
     * @param machineName The machine name registered via the big board setup process, 
     * a client certificate is required.
     * @return The division/site code mapped to the 
     * @throws DataAccessException
     */
	String getSiteCode(String machineName) throws DataAccessException;
}
