package gov.va.med.edp.dao;

import gov.va.med.edp.vo.SessionVO;
import org.springframework.dao.DataAccessException;

/**
 * Data Access Interface for retrieving session information through commands within Vista.
 *
 */
public interface SessionDao {
    /**
     * Retrieve session information.
     * @param stationNumber This division number.
     * @param duz The user duz.
     * @return The session information.
     * @throws DataAccessException
     */
	SessionVO getSessionInfo(String stationNumber, String duz) throws DataAccessException;
}
