package gov.va.med.edp.dao;

import gov.va.med.edp.vo.BigBoardDebugInfoVO;
import gov.va.med.edp.vo.BigBoardSessionInfoVO;

import org.springframework.dao.DataAccessException;

/**
 * Data Access Interface for retrieving information through commands within Vista.
 *
 */
public interface ServerPackageVersionDao {
    /**
     * Retrieve the server package version.
     * @param stationNumber The division number for a particular VAMC.
     * @return The version of the server package.
     */
    String getServerPackageVersion(String stationNumber);
    /**
     * Retrieve the big board data to store in the session.
     * @param stationNumber The division number for a particular VAMC.
     * @param boardName The board name associated with this data.
     * @return The big board session information.
     */
    BigBoardSessionInfoVO getBigBoardSessionInfo(String stationNumber, String boardName);
    /**
     * Retrieve the vista link connection information for a particular division.
     * 
     * @param stationNumber The division number for a particular VAMC.
     * @return The vista link connection information.
     * @throws DataAccessException
     */
    BigBoardDebugInfoVO getVistaLinkConnectionInfo(String stationNumber) throws DataAccessException;
}
