package gov.va.med.edp.vitals.control
{
//import gov.va.med.edp.rpc.AbstractFaultHandlingResponder;

import gov.va.med.edp.vitals.dao.VitalsXml;
import gov.va.med.edp.vitals.model.VitalsModel;
import mx.rpc.IResponder;
	import mx.rpc.events.ResultEvent;

	//public class GetVitalsResponder extends AbstractFaultHandlingResponder implements IResponder
	public class GetVitalsResponder implements IResponder
	{
		private var model:VitalsModel;
		
			private var vitalsXml:XML = <result>
							<TrackVitals dfn="229" frequency="2" trackStarting="3080922.1552">
								<trackVital name="Blood Pressure" symbl="P" track="true"/>
								<trackVital name="Temperature" symbl="T" track="true"/>
								<trackVital name="Respiration" symbl="R" track="true"/>
								<trackVital name="Weight" symbl="WT" track="true"/>
								<trackVital name="Height" symbl="HT" track="true"/>
								<trackVital name="Pain" symbl="PN" track="true"/>																
							</TrackVitals>						 
							<Vitals dfn="229">
								<vital BP="100/70" HT="70" P="75" PN="4" R="59" T="96.1" WT="210" error="false" time="3080922.1552" />
								<vital BP="105/75" HT="70" P="77" PN="5" R="62" T="96.7" WT="210" error="false" time="3080922.1602" />
								<vital BP="130/88" HT="70" P="72" PN="6" R="65" T="99.8" WT="215" error="false" time="3090115.1633" />
								<vital BP="155/95" HT="70" P="78" PN="7" R="68" T="100.5" WT="215" error="false" time="3090115.1639" />
								<vital BP="170/120" HT="70" P="76" PN="5" R="65" T="101" WT="215" error="false" time="3090115.1718" />
							</Vitals>
						</result>;		

        public function GetVitalsResponder(model:VitalsModel):void {
            this.model = model;
        }

        //public override function result(data:Object): void
	public function result(data:Object): void	
		{
			var xml:XML = ResultEvent(data).result as XML;
			var vitalNode:XML = xml.Vitals[0];
			model.patientDfn = vitalNode.@dfn;
			model.trackVitals = VitalsXml.buildTrackVitals(vitalsXml.TrackVitals);
			model.vitals = VitalsXml.buildVitals(xml.Vitals);

		}
		
		//public override function fault(info:Object): void
		public function fault(info:Object): void
		{
			super.fault(info);
		}
		
	} // class
} // package