package gov.va.med.edp.log.model {
//import gov.va.med.edp.core.model.ApplicationViewModel;
import mx.collections.ArrayCollection;


[Bindable]
public class LogEditorModel {
	//public var view:ApplicationViewModel;

	public var logEntryViewState: String = "";

	public var logArea: int;
	public var logEntryList: LogEntryList = new LogEntryList();
	public var logEdit: LogEdit = new LogEdit();
	public var logEditParams: LogEditParamsVO;

	public var matchingDiagnoses: ArrayCollection;
	public var matchingDiagnosesLoaded: Boolean = false;

	public var matchingClosedVisits: ArrayCollection;
	public var matchingClosedVisitsIndex: int = -1;

	public function entryRemoveReady(): void
	{
		var ready: Boolean = true;

		// special dispositions that allow immediate removal
		if ((logEdit.entry.disposition == logEditParams.errorIEN) ||
			(logEdit.entry.disposition == logEditParams.nurseEvalIEN) ||
			(logEdit.entry.disposition == logEditParams.leftIEN)) {
			logEdit.entry.removeReady = true;
			return;
		}

		if (logEdit.entry.requireDiagnosis && (logEdit.entry.diagnoses.length == 0)) {
			ready = false;
		}
		if (logEdit.entry.requireDisposition &&
			((logEdit.entry.disposition == logEditParams.emptyValue) ||
			 (logEdit.entry.disposition < 1))) {
			ready = false;
		}
		if (logEdit.entry.requireDelay &&
			((logEdit.entry.delay == logEditParams.emptyValue) ||
			 (logEdit.entry.delay < 1))) {
			ready = false;
		}

		logEdit.entry.removeReady = ready;
	}

	public function synchToLastEntry(): void
	{
		for (var i:int = 0; i < logEntryList.entries.length; i++) {
			var logSelector: LogSelectorVO = logEntryList.entries[i];
			if (logSelector.id == logEdit.entry.id) {
				logEntryList.selectedIndex = -1;  // force binding to fire
				logEntryList.selectedIndex = i;
				logEntryList.selectedID = logSelector.id;
				return;
			} // if
		} // for
	} // synchToLastEntry

	public function synchToClosedEntry(): void
	{
		for (var i: int = 0; i < matchingClosedVisits.length; i++) {
			var visit: VisitVO = matchingClosedVisits[i];
			if (visit.id == logEdit.entry.id) {
				matchingClosedVisitsIndex = -1;  // force binding to fire
				matchingClosedVisitsIndex = i;
				return;
			} // if
		} // for
	} // synchToClosedEntry

	public function setEditState(): void
	{
		// always start at the beginning
		logEntryViewState = "";

		if (logEdit.entry == null) {
			logEntryViewState = LogEditorViewState.VIEW_EDIT_MESSAGE;
			return;
		}

		// convenient place to clear lookup list since this is called when entry changes
		matchingDiagnoses = null;

		//switch (view.appViewState) {
		//	case ApplicationViewModel.VIEW_APP_SIGN_IN:
		//		logEntryViewState = LogEditorViewState.VIEW_EDIT_SIGN_IN;
		//		break;
		//	case ApplicationViewModel.VIEW_APP_TRIAGE:
		//		logEntryViewState = LogEditorViewState.VIEW_EDIT_TRIAGE;
		//		break;
		//	case ApplicationViewModel.VIEW_APP_UPDATE:
		//		logEditParams.promptResidents ?
		//		logEntryViewState = LogEditorViewState.VIEW_EDIT_UPDATE : logEntryViewState = LogEditorViewState.VIEW_EDIT_UPDATE_NORES;
		//		break;
		//	case ApplicationViewModel.VIEW_APP_DISPOSITION:
		//		logEditParams.codedDiagnosis ?
		//		logEntryViewState = LogEditorViewState.VIEW_EDIT_DISP_DELAY_CODED :
		//		logEntryViewState = LogEditorViewState.VIEW_EDIT_DISP_DELAY;
		//		break;
		//	case ApplicationViewModel.VIEW_APP_EDIT_CLOSED:
		//		logEditParams.codedDiagnosis ?
		//		logEntryViewState = LogEditorViewState.VIEW_EDIT_CLOSED_CODED :
		//		logEntryViewState = LogEditorViewState.VIEW_EDIT_CLOSED;
		//		break;
		//	default:
		//		logEntryViewState = LogEditorViewState.VIEW_EDIT_MESSAGE;
		//		break;
		//} // switch
	} // setEditState
}
}