package gov.va.med.edp.log.model
{
import gov.va.med.edp.log.model.LogEntryVO;
import mx.collections.ArrayCollection;
	
	[Bindable]
	public class LogEdit
	{
		public var entry: LogEntryVO;
		public var undo: LogEntryVO;
		
		public var processedSensitivePatient:Boolean = false;
		public var patientSelected: Boolean = false;
		public var dirty: Boolean = false;
		public var message: String = "No visit currently selected.";
		public var choiceTS: String = "";
		public var removeMessage: String = "";
		
		public var arrivals: ArrayCollection;
		public var statuses: ArrayCollection;
		public var acuities: ArrayCollection;
		public var beds: ArrayCollection;
		public var providers: ArrayCollection;
		public var residents: ArrayCollection
		public var nurses: ArrayCollection;
		public var delays: ArrayCollection;
		public var dispositions: ArrayCollection;
		
		public function setEntry(value: LogEntryVO): void
		{
			entry = value;
			message = "";
		}
		
		/* called if entry is no longer open */
		public function resetEntry(): void
		{
			entry = null;
			this.dirty = false;
			this.message = "No visit currently selected.";
		}
 	}
}
