package gov.va.med.edp.log.dao {
import gov.va.med.edp.log.model.VisitVO;
import gov.va.med.edp.log.model.LogSelectorVO;
import gov.va.med.edp.log.model.LogEditParamsVO;
//import gov.va.med.edp.core.dao.SessionXml;
//import gov.va.med.edp.core.model.LookupStringVO;
import gov.va.med.edp.log.model.LogEdit;
import gov.va.med.edp.pt.demog.dao.PatientXml;
import mx.collections.ArrayCollection;
//import gov.va.med.edp.core.model.PCECodedValueVO;
import gov.va.med.edp.log.model.LogEntryVO;
import gov.va.med.edp.util.Vista;
public class LogXml {
	public static function buildLogEditParamsFromXML(xml: XML): LogEditParamsVO
	{
		var logEditParamsVO: LogEditParamsVO = new LogEditParamsVO();
		logEditParamsVO.requireDiagnosis = (xml.@reqDiag == "1");
		logEditParamsVO.requireDisposition = (xml.@reqDisp == "1");
		logEditParamsVO.requireDelay = (xml.@reqDelay == "1");
		logEditParamsVO.delayMinutes = int(xml.@minDelay);
		logEditParamsVO.codedDiagnosis = (xml.@codedDiag == "1");
		logEditParamsVO.shiftStart = int(xml.@shiftOne);
		logEditParamsVO.shiftDuration = int(xml.@shiftLen);
		logEditParamsVO.promptResidents = (xml.@residents == "1");
		logEditParamsVO.ambulanceArea = int(xml.@ambulance);
		logEditParamsVO.defaultRoom = int(xml.@dfltroom);
		logEditParamsVO.emptyValue = int(xml.@emptyIEN);
		logEditParamsVO.errorIEN = int(xml.@errorIEN);
		logEditParamsVO.nurseEvalIEN = int(xml.@evalIEN);
		logEditParamsVO.leftIEN = int(xml.@leftIEN);
		return logEditParamsVO;
	}


	/* buildLogSelectorListFromXML expects:
	 <anyRoot>
	 <anyNode id="9999" dfn="99" ptNm="XXXX" ssn="999999999" last4="X9999"
	 dob="2380106" bed="XXX" same="1" />
	 ...
	 </anyRoot> */
	public static function buildLogSelectorListFromXML(nodeList: XMLList): Array
	{
		var logSelectorVO: LogSelectorVO;
		var logSelectorList: Array = [];
		for each (var item: XML in nodeList) {
			logSelectorVO = new LogSelectorVO();
			logSelectorVO.id = Number(item.@id);
			logSelectorVO.name = item.@name;
			logSelectorVO.ssn = item.@ssn;
			logSelectorVO.last4 = item.@last4;
			logSelectorVO.bed = item.@bed;
			logSelectorVO.dfn = item.@dfn;
			logSelectorVO.similar = (item.@same == "1") ? true : false;
			logSelectorList.push(logSelectorVO);
		}
		return logSelectorList;
	}

	public static function buildLogEntryFromXML(xml:XML):LogEntryVO
	{
		var logEntryVO:LogEntryVO = new LogEntryVO();
		logEntryVO.id = xml.id;
		logEntryVO.site = xml.site;
		logEntryVO.area = xml.area;
		logEntryVO.dfn = xml.dfn;
		logEntryVO.name = xml.name;
		logEntryVO.ssn = xml.ssn;
		logEntryVO.dob = xml.dob;
		logEntryVO.arrival = int(xml.arrival);
		logEntryVO.inTS = Vista.FMtoDate(xml.inTS);
		logEntryVO.visit = int(xml.visit);
		logEntryVO.complaint = xml.complaint;
		logEntryVO.longComplaint = xml.compLong;
		logEntryVO.status = int(xml.status);
		logEntryVO.acuity = int(xml.acuity);
		logEntryVO.bed = int(xml.bed);
		logEntryVO.provider = xml.md;
		logEntryVO.resident = xml.res;
		logEntryVO.nurse = xml.nurse;
		logEntryVO.comment = xml.comment;
		logEntryVO.outTS = Vista.FMtoDate(xml.outTS);
		logEntryVO.delay = int(xml.delay);
		logEntryVO.disposition = int(xml.disposition);
		logEntryVO.diagnoses = new ArrayCollection();
		logEntryVO.patientFlags = PatientXml.buildPtRecordFlagsFromXML(xml.patientRecordFlags.flag);
		logEntryVO.loadTS = xml.loadTS;

		for each (var item: Object in xml.diagnosis) {
			//var pceItem: PCECodedValueVO = new PCECodedValueVO;
			//pceItem.type = item.@type;
			//pceItem.ien = int(item.@ien);
			//pceItem.code = item.@code;
			//pceItem.label = item.@label;
			//pceItem.primary = (item.@primary == "1");
			//pceItem.quantity = int(item.@qty);
			//logEntryVO.diagnoses.addItem(pceItem);
		}

		var required:String = xml.required;

		logEntryVO.required = required;
		logEntryVO.removeReady = (logEntryVO.required.length == 0);

		if (required.indexOf("diag") != -1) logEntryVO.requireDiagnosis = true;
		if (required.indexOf("disp") != -1) logEntryVO.requireDisposition = true;
		if (required.indexOf("delay") != -1) logEntryVO.requireDelay = true;

		return logEntryVO;
	}

	public static function buildVisitListFromXML(nodeList: XMLList): ArrayCollection
	{
		var list: ArrayCollection = new ArrayCollection();
		if (nodeList.length() == 0) {
			var emptyVisit: VisitVO = new VisitVO();
			emptyVisit.id = -1;
			emptyVisit.name = "No matches found.";
			list.addItem(emptyVisit);
			return list;
		} else {
			for each (var item: XML in nodeList) {
				var visit: VisitVO = new VisitVO();
				visit.id = item.@id;
				visit.name = item.@name;
				visit.inTS = Vista.FMtoDate(item.@inTS);
				list.addItem(visit);
			}
			return list;
		}
	}

	public static function buildLookupDiagnosesListFromXML(xml:XML): ArrayCollection
	{
		//var codedValueVO: PCECodedValueVO;
		var diagnosesSelectList: ArrayCollection = new ArrayCollection();

		//Add support for no matches found..
		if (xml.children().children().length() == 0) {
			//codedValueVO = new PCECodedValueVO;
			//codedValueVO.code = "";
			//codedValueVO.label = "No matches found.";
			//diagnosesSelectList.addItem(codedValueVO);
		} else {
			for each (var item:XML in xml.children().children()) {
				//codedValueVO = new PCECodedValueVO();
				var code:String = item.@code;
				if (code == null || code == "")	code = item.@cpt;
				//codedValueVO.type = item.@type;
				//codedValueVO.ien = item.@ien;
				//codedValueVO.code = item.@code;
				//codedValueVO.label = item.@text;
				//diagnosesSelectList.addItem(codedValueVO);
			}
		}
		return diagnosesSelectList;
	}

	public static function setChoices(logEdit:LogEdit, xml:XML):void
	{
		// make sure the choices are set up before setting the logEntry
		logEdit.choiceTS = xml.@ts;

		if (xml.hasOwnProperty("bedList")) {
			//logEdit.beds = SessionXml.buildLookupStringListFromXML(xml.bedList.bed);
		}
		if (xml.hasOwnProperty("mdList")) {
			//logEdit.providers = SessionXml.buildLookupStringListFromXML(xml.mdList.md);
		}
		if (xml.hasOwnProperty("resList")) {
			//logEdit.residents = SessionXml.buildLookupStringListFromXML(xml.resList.res);
		}
		if (xml.hasOwnProperty("nurseList")) {
			//logEdit.nurses = SessionXml.buildLookupStringListFromXML(xml.nurseList.nurse);
		}
		if (xml.hasOwnProperty("arrivalList")) {
			//logEdit.arrivals = SessionXml.buildLookupStringListFromXML(xml.arrivalList.arrival);
		}
		if (xml.hasOwnProperty("acuityList")) {
			//logEdit.acuities = SessionXml.buildLookupStringListFromXML(xml.acuityList.acuity);
		}
		if (xml.hasOwnProperty("statusList")) {
			//logEdit.statuses = SessionXml.buildLookupStringListFromXML(xml.statusList.status);
		}
		if (xml.hasOwnProperty("delayList")) {
			//logEdit.delays = SessionXml.buildLookupStringListFromXML(xml.delayList.delay);
		}
		if (xml.hasOwnProperty("dispositionList")) {
			//logEdit.dispositions = SessionXml.buildLookupStringListFromXML(xml.dispositionList.disposition);
		}

		// add selections to the comboboxes for the persons in the current record, if necessary
		insertValues(logEdit.providers, xml.persons.provider[0]);
		insertValues(logEdit.nurses, xml.persons.nurse[0]);
		insertValues(logEdit.residents, xml.persons.resident[0]);
		insertValues(logEdit.arrivals, xml.selected.arrival[0]);
		insertValues(logEdit.statuses, xml.selected.status[0]);
		insertValues(logEdit.delays, xml.selected.delay[0]);
		insertValues(logEdit.dispositions, xml.selected.disposition[0]);
	}

	private static function insertValues(collection: ArrayCollection, xml:XML): void
	{
		removeTransients(collection);

		if (xml == null) return;
		if (xml.@data == "") return;

		var index:int = Vista.locateIndex(collection, xml.@data);
		if (index < 0) {
			//var lookup: LookupStringVO = new LookupStringVO;
			//lookup.data = xml.@data;
			//lookup.label = xml.@label;
			//lookup.transient = true;
			//ArrayCollection(collection).addItemAt(lookup, 1);
			// TODO:  add to the end of the list then sort the collection
		}
	}

	private static function removeTransients(collection: ArrayCollection): void
	{
		for (var i: int = 0; i < collection.length; i++) {
			//var lookupItem: LookupStringVO = collection[i];
			//if (lookupItem.transient) {
			//	collection.removeItemAt(i);
			//}
		}
	}

}
}