package gov.va.med.edp.log.control
{
	import gov.va.med.edp.log.model.LogEditorModel;
    //import gov.va.med.edp.rpc.AbstractFaultHandlingResponder;

	import gov.va.med.edp.log.dao.LogXml;

	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;
	import gov.va.med.edp.log.model.LogEntryVO;

	//public class SwitchLogEntryResponder extends AbstractFaultHandlingResponder implements IResponder
	public class SwitchLogEntryResponder implements IResponder
	{
		private var model:LogEditorModel;

        public function SwitchLogEntryResponder(model:LogEditorModel):void {
            this.model = model;
        }

        //public override function result(data:Object): void
	public function result(data:Object): void
		{
			var xml:XML = ResultEvent(data).result as XML;
			
			// make sure the choices are set up before setting the logEntry
			LogXml.setChoices(model.logEdit, xml.choices[0]);
			
			// now that the choices are in place, we can set the log entry
			model.logEdit.setEntry(LogXml.buildLogEntryFromXML(xml.logEntry[0]));
			model.logEdit.undo = new LogEntryVO;  // used for resetting status right now
			model.logEdit.entry.copyTo(model.logEdit.undo);
			model.logEdit.dirty = false;
			model.logEdit.patientSelected = false;
			model.entryRemoveReady();
			model.setEditState();
		}
		
		//public override function fault(info:Object): void
		public function fault(info:Object): void
		{
			model.synchToLastEntry();
			super.fault(info);
		}
		
	} // class
} // package