package gov.va.med.edp.log.control
{
import gov.va.med.edp.log.model.LogEditorViewState;
import gov.va.med.edp.log.ILogEntryController;
import gov.va.med.edp.log.model.LogEditorModel;
//import gov.va.med.edp.rpc.AbstractFaultHandlingResponder;

import gov.va.med.edp.widget.InfoDialog;

import mx.rpc.IResponder;
import mx.rpc.events.FaultEvent;
import mx.rpc.events.ResultEvent;

//public class SaveLogEntryResponder extends AbstractFaultHandlingResponder implements IResponder
public class SaveLogEntryResponder implements IResponder
{
	private var model:LogEditorModel;
	private var controller:ILogEntryController;

	public function SaveLogEntryResponder(controller:ILogEntryController, model:LogEditorModel) {
		this.model = model;
	}

	//public override function result(data:Object):void
	public function result(data:Object):void
	{
		var xml:XML = ResultEvent(data).result as XML;

		if (xml.upd.@status == "fail") {
			var msg: String = xml.upd.@msg;
			InfoDialog.show("Unable to save,  " + msg);
			model.logEdit.dirty = true;
			model.synchToLastEntry();
			if (msg.indexOf("Delay Reason") > -1) {
				model.logEdit.entry.requireDelay = true;
			}
		} else if (xml.upd.@status == "collision") {
			InfoDialog.show(xml.upd, "Updated Entry");
			model.logEdit.dirty = true;
			model.synchToLastEntry();
			model.logEdit.entry.loadTS = xml.upd.@loadTS;
		} else {
			model.logEdit.resetEntry();
			model.logEdit.message = "Entry saved.";
			model.logEntryViewState = LogEditorViewState.VIEW_EDIT_MESSAGE;
			model.logEntryList.selectedIndex = -1;
			model.logEntryList.selectedID = 0;

			controller.refreshLogSelector();
		}
	}

	//public override function fault(info:Object):void
	public function fault(info:Object):void
	{
		model.logEdit.dirty = true;
		model.synchToLastEntry();
		super.fault(info);
	}
}
}