package gov.va.med.edp.log.control {
import gov.va.med.edp.log.ILogEntryDao;
import gov.va.med.edp.log.model.LogSelectorVO;
import gov.va.med.edp.pt.demog.model.PatientSelectVO;
import gov.va.med.edp.log.model.LogEditorViewState;
import mx.collections.ArrayCollection;
import mx.collections.Sort;
import mx.collections.SortField;
import gov.va.med.edp.util.Vista;

//import gov.va.med.edp.core.model.SessionVO;
//import gov.va.med.edp.core.model.PCECodedValueVO;
import gov.va.med.edp.log.model.LogEditorModel;
import gov.va.med.edp.log.dao.LogXml;

//import gov.va.med.edp.rpc.FunctionCallbackResponder;
import mx.rpc.events.ResultEvent;
import gov.va.med.edp.log.model.LogEntryVO;
import gov.va.med.edp.log.ILogEntryController;
import gov.va.med.edp.widget.InfoDialog;

public class LogEntryController implements ILogEntryController {

	[Bindable]
	public var model:LogEditorModel;

	//[Bindable]
	//public var session:SessionVO;

	[Bindable]
	public var dao:ILogEntryDao;

	public function initLogArea(area:int, entry:LogEntryVO = null):void {
		model.logArea = area;
		//dao.initLogArea(new FunctionCallbackResponder(initLogAreaResultHandler), area, entry);
	}

	private function initLogAreaResultHandler(data:Object):void {
		var xml:XML = ResultEvent(data).result as XML;

		if (xml.udp.@status == "fail") {
			InfoDialog.show("Update failed: " + xml.upd.@msg);
			return;
		}

		model.logEditParams = LogXml.buildLogEditParamsFromXML(XML(xml.params));

		if (xml.logEntries.@status == "new") {
			model.logEntryList.entries =
			new ArrayCollection(LogXml.buildLogSelectorListFromXML(xml.logEntries.log));
			model.logEntryList.token = xml.logEntries.@token;
			model.logEntryList.selectedIndex = -1;
			model.logEntryList.sortField = "";
			model.logEntryList.sortDescending = false;
			model.logEntryViewState = LogEditorViewState.VIEW_EDIT_MESSAGE;
		}
	}

	public function switchLogEntry(logID:Number, selectedIndex:int):void {
		model.logEntryList.selectedIndex = selectedIndex;
		model.logEntryList.selectedID = logID;

		dao.switchLogEntry(new SwitchLogEntryResponder(model), logID, null, model.logEdit.choiceTS);
	}

	public function sortHeader(field:String, descending:Boolean):void {
		model.logEntryList.sortField = field;
		model.logEntryList.sortDescending = descending;
	}

	public function addPatientToLog(patient:PatientSelectVO):void {
		//var localTime: String = Vista.DatetoFM(session.now());
		//dao.addPatientToLog(new AddPatientToLogResponder(model), patient, model.logArea, localTime, model.logEdit.choiceTS)
	}

	public function refreshLogSelector():void {
		//dao.refreshLogSelector(new FunctionCallbackResponder(refreshLogSelectorResultHandler), model.logArea, model.logEntryList.token)
	}

	private function refreshLogSelectorResultHandler(data:Object):void {
		var xml:XML = ResultEvent(data).result as XML;

		//DONOT refresh if the Dirty flags is true. This is because the ChangeWatcher keeps different
		//components in sync but if the user is still editing and the referesh comes in the components get
		//out of sync..
		//ALSO only refresh the list if it has changed
		if (!model.logEdit.dirty && xml.logEntries.@status == "new") {
			model.logEntryList.entries =
			new ArrayCollection(LogXml.buildLogSelectorListFromXML(xml.logEntries.log));
			model.logEntryList.token = xml.logEntries.@token;

			// sort based on previous settings
			if (model.logEntryList.sortField.length > 0) {
				var sort:Sort = new Sort();
				sort.fields = [new SortField(model.logEntryList.sortField, true, model.logEntryList.sortDescending)];
				model.logEntryList.entries.sort = sort;
				model.logEntryList.entries.refresh();
			}
			// now that it is sorted, reset the selected index (must set initial -1 to fire bindings)
			model.logEntryList.selectedIndex = -1;
			model.logEntryList.selectedIndex =
			Vista.locateIndex(model.logEntryList.entries, model.logEntryList.selectedID, "id");
			// if the ID is no longer in the list, the entry must be closed
			if ((model.logEntryList.selectedIndex == -1) && (model.logEntryList.selectedID > 0)) {
				model.logEdit.resetEntry();
				model.logEdit.message = "The selected entry has been closed.";
				model.logEntryViewState = LogEditorViewState.VIEW_EDIT_MESSAGE;
			}
		}
	}

	public function changeLogEntryField(field: String,
										value: *,
										label: String = null,
										reference: String = null,
										clear: Boolean = false):void {
		model.logEdit.dirty = true;

		switch (field)
				{
			case "patient":
			// set the name, ssn, and dfn all at once
				var patientVO: PatientSelectVO = value as PatientSelectVO;
				if ((model.logEdit.entry != null && model.logEdit.entry.name == "(ambulance)") &&
					(patientVO.name != "(ambulance)") &&
					(model.logEdit.entry.inTS == null)) {
					//model.logEdit.entry.inTS = session.now();
					model.logEdit.patientSelected = true;
				}
				model.logEdit.entry.name = patientVO.name;
				model.logEdit.entry.ssn = patientVO.ssn;
				model.logEdit.entry.dob = patientVO.dob;
				model.logEdit.entry.dfn = patientVO.dfn;
				synchSelector("name", patientVO.name);
				synchSelector("ssn", patientVO.ssn);
				break;
			case "name":
				model.logEdit.entry.name = value;
				synchSelector(field, label);
				break;
			case "ssn":
				model.logEdit.entry.ssn = value;
				synchSelector(field, label);
				break;
			case "inTS":
				model.logEdit.entry.inTS = value;
				break;
			case "outTS":
				model.logEdit.entry.outTS = value;
				break;
			case "complaint":
				model.logEdit.entry.complaint = value;
				break;
			case "longComplaint":
				model.logEdit.entry.longComplaint = value;
				break;
			case "arrival":
				model.logEdit.entry.arrival = value;
				break;
			case "bed":
				model.logEdit.entry.bed = value;
				if (int(reference) > 0) {
					model.logEdit.entry.status = int(reference);
				} else {
					if (model.logEdit.undo != null) {
						model.logEdit.entry.status = model.logEdit.undo.status;
					}
				}
			// don't synch until "save"
			// synchSelector(field, label);
				break;
			case "acuity":
				model.logEdit.entry.acuity = value;
				break;
			case "status":
				model.logEdit.entry.status = value;
				break;
			case "provider":
				model.logEdit.entry.provider = value;
				break;
			case "resident":
				model.logEdit.entry.resident = value;
				break;
			case "nurse":
				model.logEdit.entry.nurse = value;
				break;
			case "comment":
				model.logEdit.entry.comment = value;
				break;
			case "disposition":
				model.logEdit.entry.disposition = value;
				model.entryRemoveReady();
				break;
			case "delay":
				model.logEdit.entry.delay = value;
				model.entryRemoveReady();
				break;
			case "diagnoses":
				//var pceItem: PCECodedValueVO = value as PCECodedValueVO;
				if (clear) {
					// clear means we want to remove the item
					//var index: int = model.logEdit.entry.diagnoses.getItemIndex(pceItem);
					//if (pceItem.added) {
						// remove from list if we just added it in this session
					//	model.logEdit.entry.diagnoses.removeItemAt(index);
					//} else {
						// otherwise set remove to true so PCE can remove it
					//	model.logEdit.entry.diagnoses[index].remove = true;
					//}
				//} else if (pceItem.updated) { // MAKE SURE THAT UPDATE IS CHECKED BEFORE ADD..
					//pceItem.updated = true	// BECAUSE AN ITEM CAN BE ADDED AND THEN UPDTED IN THE SAME SESSION
					//model.logEdit.entry.diagnoses[index].updated = true;
				//} else if (pceItem.added) {
					//pceItem.added = true;
					//model.logEdit.entry.diagnoses.addItem(pceItem);
				}
				model.logEdit.entry.updatedDiagnoses = true;
				model.entryRemoveReady();
				break;
		} // switch
	}

	private function synchSelector(field: String, label: String): void
	{
		var logSelector: LogSelectorVO = findLogSelector();
		if (logSelector == null) return;

		switch (field)
				{
			case "name":
				logSelector.name = label;
				break;
			case "ssn":
				logSelector.ssn = label;
				break;
			case "bed":
				logSelector.bed = label;
				break;
		} // switch
	} // synchSelector

	private function findLogSelector(): LogSelectorVO
	{
		for each (var logSelector: LogSelectorVO in model.logEntryList.entries) {
			if (logSelector.id == model.logEdit.entry.id) {
				return logSelector;
			}
		}
		return null;
	}

	public function removeLogEntry():void {
		//dao.removeLogEntry(new FunctionCallbackResponder(removeLogEntryResultHandler), model.logEdit.entry, model.logArea);
		model.logEdit.dirty = false;
	}

	private function removeLogEntryResultHandler(data:Object):void {
		var xml:XML = ResultEvent(data).result as XML;

		// bail if the update of the changed log entry failed
		if (xml.upd.@status == "fail") {
			InfoDialog.show("Removal of log entry failed.\n" + xml.upd.@msg);
			return;
		}

		// clear the current record
		model.logEdit.resetEntry();
		model.logEdit.message = "Patient removed from board.";
		model.logEntryViewState = LogEditorViewState.VIEW_EDIT_MESSAGE;
		model.logEntryList.selectedIndex = -1;
		model.logEntryList.selectedID = 0;

		// refresh the list of log entries
		model.logEntryList.entries =
		new ArrayCollection(LogXml.buildLogSelectorListFromXML(xml.logEntries.log));
		model.logEntryList.token = xml.logEntries.@token;

		// sort based on previous settings
		if (model.logEntryList.sortField.length > 0) {
			var sort:Sort = new Sort();
			sort.fields = [new SortField(model.logEntryList.sortField, true, model.logEntryList.sortDescending)];
			model.logEntryList.entries.sort = sort;
			model.logEntryList.entries.refresh();
		}
	}

	public function saveLogEntry():void {
		if (model.logEdit.dirty) {
			model.logEdit.dirty = false;
			dao.saveLogEntry(new SaveLogEntryResponder(this, model), model.logEdit.entry);
		}
	}

	public function deleteStubEntry():void {
		if (model.logEdit.entry.isStub) {
			model.logEdit.dirty = false;
			dao.deleteStubEntry(new DeleteStubEntryResponder(this, model),model.logArea, model.logEdit.entry.id);
		}
	}

	public function cancelEdit():void {
		model.logEdit.resetEntry();
		model.logEntryViewState = LogEditorViewState.VIEW_EDIT_MESSAGE;
		model.logEntryList.selectedIndex = -1;
		model.logEntryList.selectedID = 0;
	}

	public function matchClosedVisits(partial:String):void {
		if ((partial == null) || (partial.length == 0)) {
			model.matchingClosedVisits = null;
			return;
		}

		//dao.matchClosedVisits(new FunctionCallbackResponder(matchClosedVisitsResultHandler), model.logArea, partial);
	}

	private function matchClosedVisitsResultHandler(data:Object):void {
		var xml:XML = ResultEvent(data).result as XML;
		model.matchingClosedVisits = LogXml.buildVisitListFromXML(xml.visit);
		model.logEdit.resetEntry();
		model.setEditState();
		model.matchingClosedVisitsIndex = -1;
	}

	public function matchDiagnoses(partial:String):void {
		if ((partial == null) || (partial.length == 0)) {
			model.matchingDiagnoses = null;
			return;
		}

		//dao.matchDiagnoses(new FunctionCallbackResponder(matchDiagnosesResultHandler), partial);
	}

	private function matchDiagnosesResultHandler(data:Object):void {
		model.matchingDiagnosesLoaded = false;
		var xml:XML = ResultEvent(data).result as XML;
		model.matchingDiagnoses =
		LogXml.buildLookupDiagnosesListFromXML(xml);
		model.matchingDiagnosesLoaded = true;
	}

	public function clearUnsavedViews():void {
		model.logEdit.dirty = false;
	}
}
}