/* DeleteStubEntryCommand.as */
	
package gov.va.med.edp.log.control
{
import gov.va.med.edp.log.model.LogEditorViewState;
//import gov.va.med.edp.rpc.AbstractFaultHandlingResponder;
import gov.va.med.edp.log.model.LogEditorModel;
import gov.va.med.edp.log.ILogEntryController;

	import gov.va.med.edp.widget.InfoDialog;
	
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;

	//public class DeleteStubEntryResponder extends AbstractFaultHandlingResponder implements IResponder
	public class DeleteStubEntryResponder implements IResponder
	{
        private var controller:ILogEntryController;
        private var model:LogEditorModel;

        public function DeleteStubEntryResponder(controller:ILogEntryController, model:LogEditorModel):void {
            this.controller = controller;
            this.model = model;
        }

        //public override function result(data:Object):void
	public function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;

			if (xml.upd.@status == "fail") {
				InfoDialog.show("Cancel failed: " + xml.upd.@msg);
				model.logEdit.dirty = true;
				model.synchToLastEntry();
			} else {
				model.logEdit.resetEntry();
				model.logEdit.message = "No visit currently selected.";
				model.logEntryViewState = LogEditorViewState.VIEW_EDIT_MESSAGE;
				model.logEntryList.selectedIndex = -1;
				model.logEntryList.selectedID = 0;

                controller.refreshLogSelector();
			}
		}
		
		//public override function fault(info:Object):void
		public function fault(info:Object):void
		{
			model.logEdit.dirty = true;
			model.synchToLastEntry();
			super.fault(info);
		}
	}
}