package gov.va.med.edp.log {
import gov.va.med.edp.log.model.LogEntryVO;
import gov.va.med.edp.pt.demog.model.PatientSelectVO;
public interface ILogEntryController {

	function initLogArea(area:int, entry:LogEntryVO = null):void;

	function switchLogEntry(logID:Number, selectedIndex:int):void;

	function sortHeader(field:String, descending:Boolean):void;

	function addPatientToLog(patient:PatientSelectVO):void;

	function refreshLogSelector():void;

	function changeLogEntryField(field: String,
								 value: *,
								 label: String = null,
								 reference: String = null,
								 clear: Boolean = false):void;

	function removeLogEntry():void;

	function saveLogEntry():void;

	function deleteStubEntry():void;

	function cancelEdit():void;

	function matchClosedVisits(partial:String):void;

	function matchDiagnoses(partial:String):void;

	function clearUnsavedViews():void;
}
}