package gov.va.med.edp.widget.accessibility
{
	import flash.accessibility.Accessibility;
	import flash.events.Event;
	
	import mx.accessibility.AccImpl;
	import mx.core.UIComponent;
	import mx.core.mx_internal;
	
	import gov.va.med.edp.widget.AccessibleNumericStepper;
	
	use namespace mx_internal;
	
	/**
     *  The class is used to create or access the numericstepper component.
     *
     *  @tiptext This is the NumericStepperAccImpl Accessibility Class.
     *  @created by jtorreno 6.2.2008
     */
	public class NumericStepperAccImpl extends AccImpl
	{ 
		
		/**
		 * @private
		 * Default role for numericstepper
		*/ 
	    private const ROLE_SYSTEM_TEXT:uint = 0x0000002A;
		
		/**
		 *  @private
		 *  Default state for all the components.
	    */
  	    private static const STATE_SYSTEM_NORMAL:uint = 0x00000000;

	    /**
	     *  @private
	    */
	    private static const STATE_SYSTEM_FOCUSABLE:uint = 0x00100000;
	
	    /**
	     *  @private
	    */
	    private static const STATE_SYSTEM_FOCUSED:uint = 0x00000004;
	
	    /**
	     *  @private
	    **/
	    private static const EVENT_OBJECT_FOCUS:uint = 0x8005;
	     
	    /**
	     *  @private
	    */
	    private static const EVENT_OBJECT_VALUECHANGE:uint = 0x0000800e;
	
        /**
	     *  @private
	     *   Accessibility hookup
	    */
        private static var accessibilityHooked:Boolean = hookAccessibility();
	
	
	    /**
         *  Constructor for NumericStepperAccImpl class.
		 * 
		 * @param master   the UI component for the numeric stepper
        */ 
	    public function NumericStepperAccImpl(master:UIComponent)
		{
		    super(master);	
	    }
		
		/**
	     *  @private
	     *  Method for creating the Accessibility class.
	     *  This method is called from UIComponent.
	     *  @review
	    */ 
		mx_internal static function createAccessibilityImplementation(
									component:UIComponent):void
		{
			component.accessibilityImplementation =
				new NumericStepperAccImpl(component);
		}
		
		/**
	     *  @private
	     *  Static method for swapping the createAccessibilityImplementation()
	     *  method of AccessibleNumericStepper with the NumericStepperAccImpl class.
	     */
		 private static function hookAccessibility():Boolean
		 {
		      AccessibleNumericStepper.createAccessibilityImplementation =
				  createAccessibilityImplementation;
	         return true;
		 }
		
		/**
	     *  Method call for enabling accessibility for a component.
	     *  this method is required for the compiler to activate
	     *  the accessibility classes for a component.
	    */
		 public static function enableAccessibility():void
		 {

		 }
		
		 /**
	     *  Method for returning the name of the NumericStepper
	     *
	     *  @param childID   the child id to get the name of the numeric stepper
	     *
	     *  @return Name  the name of the numeric stepper
	     */
		 override protected function getName(childID:uint):String
		 {
			var name:String = "";
			
			name = AccessibleNumericStepper(master).name;

			return name;
		 }
		 
		 /**
       	  *  Method for returning the value of the NumericStepper
	      *
	      *  @param childID  the child id to get the value of the numeric stepper
	      *
	      *  @return Value  the value of the numeric stepper
	      */
		 override public function get_accValue(childID:uint):String
		 {
		     var accValue:String="";
			
  			 accValue = AccessibleNumericStepper(master).value.toString();
			
			return accValue;
		 }

         /**
	     *  The IAccessible method for returning the state of the NumericStepper
	     *
	     *  @param childID the child id to get the state of the numeric stepper
	     *
	     *  @return State  the state of the numeric stepper
	     */
		 override public function get_accState(childID:uint):uint
		 {
		    var accState:uint = STATE_SYSTEM_NORMAL;
	
			if (AccessibleNumericStepper(master).getFocus())
			{	    
	 		  accState |= STATE_SYSTEM_FOCUSED;
		    }	    
		  
		    return accState;
		 }
		
		 /**
	      *  Gets the role for the component.
	      *
	      *  @param childID  the child id to get the role of the component
		  * 
		  *  @return the role of the UI component.
	     */
		 override public function get_accRole(childID:uint):uint
	     {
		 	return ROLE_SYSTEM_TEXT;
	     }
	     
	     /**
  	      *	 Array of events that we should listen for from the master component.
		  * 
		  *  @return the array of events to handle.
	      */
	     override protected function get eventsToHandle():Array
		 {
		     return super.eventsToHandle.concat(["numericStepperFocused","stepSizeChanged","stepSizeMouseClickChanged"]);
		 }
		 
		 /**
	      *  Override the generic event handler.
	      *  All AccImpl must implement this to listen for events
	      *  from its master component.
		  * 
		  *  @param event  the event to be processed 
	      */
		 override protected function eventHandler(event:Event):void
		  {
		  	  //trace("&&&&&&&&&& Event Type: " + event.type);
		      switch (event.type)
			    {
				    /* tell JAWS to update and reread the information */
				    case "stepSizeChanged":
				    {
			  	        Accessibility.sendEvent(master, 0,  EVENT_OBJECT_FOCUS);
					    Accessibility.sendEvent(master, 0,  EVENT_OBJECT_VALUECHANGE);
					    Accessibility.updateProperties();
					    break;
				    }	
				    case "stepSizeMouseClickChanged":
				    {
					    Accessibility.sendEvent(master, 0,  EVENT_OBJECT_FOCUS);
					    //Accessibility.sendEvent(master, 0, EVENT_OBJECT_STATECHANGE);
					    Accessibility.sendEvent(master, 0,  EVENT_OBJECT_VALUECHANGE);
					    Accessibility.updateProperties();
					    break;
				    }					   
				    case "numericStepperFocused":
				    {
					    Accessibility.sendEvent(master, 0,  EVENT_OBJECT_FOCUS);
					    Accessibility.sendEvent(master, 0,  EVENT_OBJECT_VALUECHANGE);
					    Accessibility.updateProperties();
					    break;
				    }
				   				   
	 	        }
		   }
			
	}
}