package gov.va.med.edp.widget.accessibility
{
	import gov.va.med.edp.widget.LinkButtonTab;
	import gov.va.med.edp.widget.LinkButtonTabBar;
	
	import mx.accessibility.TabBarAccImpl;
	import mx.core.UIComponent;
    import mx.core.mx_internal;

    use namespace mx_internal;

	/**
	 *  The class is used to create LinkButtonTabBar UI component.
	 *
	 */

    public class LinkButtonTabBarAccImpl extends TabBarAccImpl
	{
        private static const MAX_NUM:uint = 100000;

        /**
		 *  @private
		 *  Static variable triggering the hookAccessibility() method.
		 *  This is used for initializing LinkButtonTabBarAccImpl class to hook its
		 *  createAccessibilityImplementation() method to LinkButtonTabBar class
		 *  before it gets called from UIComponent.
		 */
		private static var accessibilityHooked:Boolean = hookAccessibility();
	
		/**
		 *  @private
		 *  Static method for swapping the createAccessibilityImplementation()
		 *  method of LinkButtonTabBar with LinkButtonTabBarAccImpl class.
		 */
		private static function hookAccessibility():Boolean
		{
			LinkButtonTabBar.createAccessibilityImplementation =
				createAccessibilityImplementation;
	
			return true;
		}
		
		/**
		 *  @private
		 *  Method for creating the Accessibility class.
		 *  This method is called from UIComponent.
		 *  @review
		 */
		mx_internal static function createAccessibilityImplementation(
									component:UIComponent):void
		{
			component.accessibilityImplementation =
				new LinkButtonTabBarAccImpl(component);
		}
	
		/**
		 *  Method call for enabling accessibility for a component.
		 *  This method is required for the compiler to activate
		 *  the accessibility classes for a component.
		 */
		public static function enableAccessibility():void
		{
		}
		
		/**
		 *  Constructor for LinkButtonTabBarAccImpl class.
		 *
		 *  @param master The UIComponent instance that this AccImpl instance
		 *  is making accessible.
		 */
		public function LinkButtonTabBarAccImpl(master:UIComponent)
		{
			super(master);
		}

		/**
		 *  Method for returning the name of the Tab
		 *  which is spoken out by the screen reader.
		 *
		 *  @param childID the child ID used to get the name
		 *
		 *  @return Name the name to be returned
		 */
		override protected function getName(childID:uint):String
		{
			if (childID == 0)
				return "View Selector Panel";
	
			var name:String;
	
			var tabBar:LinkButtonTabBar = LinkButtonTabBar(master);
			// Assuming childID is always ItemID + 1
			// because getChildIDArray is not always invoked.
			var index:int = childID < MAX_NUM ?
							childID - 1 :
							childID - MAX_NUM - 1;
			//With new version of JAWS, when we add a new child, we get nonsense number
			//not caught above. In this case, return last tab.
			if (index > tabBar.numChildren || index < 0)
				index = tabBar.numChildren -1;
			var item:LinkButtonTab = LinkButtonTab(tabBar.getChildAt(index));
	
			name = item.label;
	
			if (index == tabBar.selectedIndex)
				name += " Tab, Active";
			else
				name += " Tab";
	
			return name;
		}

	}
}