package gov.va.med.edp.widget.accessibility
{
    import gov.va.med.edp.widget.AutoComplete;

    import flash.accessibility.Accessibility;
	import flash.events.Event;
	
	import mx.accessibility.ComboBoxAccImpl;
	import mx.core.UIComponent;
	import mx.core.mx_internal;
	
	use namespace mx_internal;
	
	/**
     *  The AutoCompleteAccImpl class is the accessibility class for 
     *  Autocomplete component.
     *
     *  @tiptext This is the AutoCompleteAccImpl Accessibility Class.
     *  @created by jtorreno 6.2.2008
     */
	public class AutoCompleteAccImpl extends ComboBoxAccImpl
	{
		/**
		 * @private
		 */ 
		private var lastItemName:String = "No item selected";
		
	
		/**
	    *  @private
	    *  Default Role of Autocomplete component.
	    */
	   private const ROLE_SYSTEM_TEXT:uint = 0x0000002A;
  	   
  	   /**
	    *  @private
	    *  Default state for all the components.
	    */
  	   private static const STATE_SYSTEM_NORMAL:uint = 0x00000000;

       /**
	    *  @private
	    */
	   private static const STATE_SYSTEM_FOCUSED:uint = 0x00000004;
	
	   /**
	    *  @private
	    */
	   private static const EVENT_OBJECT_FOCUS:uint = 0x8005;
	     
	   /**
	    *  @private
	    */
	   private static const EVENT_OBJECT_VALUECHANGE:uint = 0x0000800e;
	    
	   /**
	    *  @private
	    *  Event emitted if 1 item is selected.
	    */
	   private static const EVENT_OBJECT_SELECTION:uint = 0x8006; 
	
	   /**
	    *  Accessibility hookup
	    *  @private
	    */
	   private static var accessibilityHooked:Boolean = hookAccessibility();
	
       /**
       *   Constructor for AutoCompleteAccImpl class
       */
      public function  AutoCompleteAccImpl(master:UIComponent)
	   {
		  super(master);	
	   }
	
	  /**
	   *  The static method for creating the Accessibility class.
	   *  This method is called from UIComponent.
	   *  @param the UI component
	 */	 
	  mx_internal static function createAccessibilityImplementation(
									component:UIComponent):void
	  {
	      component.accessibilityImplementation =
			  new AutoCompleteAccImpl(component);
	  }
		
	  /**
	 *  @private
	 *  Static variable triggering the hookAccessibility() method.
	 *  This is used for initializing AutoCompleteAccImpl class to hook its
	 *  createAccessibilityImplementation() method to AutoComplete class 
	 *  before it gets called from UIComponent.
	 */	
	  private static function hookAccessibility():Boolean
	  {
	      AutoComplete.createAccessibilityImplementation =
			  createAccessibilityImplementation;
	      
		  return true;
	  }
	
	 /**
	 *  Method call for enabling accessibility for a component.
	 *  this method is required for the compiler to activate
	 *  the accessibility classes for a component.
	 */
	  public static function enableAccessibility():void
	  {
		 
	  }
		 
	  /**
	 *  Method for returning the name of the Autocomplete
	 *
	 *  @param childID the child id to fetch name
	 *
	 *  @return Name the name to be returned
	 */
	  override protected function getName(childID:uint):String
	  {
		  super.getName(childID);
		  var name:String = "";
			
		  if (AutoComplete(master).selectedIndex == -1) {
		      name = AutoComplete(master).name ;
		  } else {
			 var lastSelectedIndx:int = AutoComplete(master).selectedIndex + 1;
			  name = "Item " +  lastSelectedIndx +
				       " of " +  AutoComplete(master).dataProvider.length;
  		  }	   
					   			
		  return name;
	   }
	  		
     /**
	 *  Method for returning the value of the Autocomplete component
	 *
	 *  @param childID the child id to fetch the auto complete component
	 *
	 *  @return Value the autocomplete component value
	 */	
	  override public function get_accValue(childID:uint):String
	  {
	  	  super.get_accValue(childID);
		  var accValue:String = "";
		  accValue = AutoComplete(master).value.toString();
		  return accValue;
	  }

     /**
	 *  Method for returning the state of the Autocomplete component
	 *
	 *  @param childID the child id to fetch the account state
	 *
	 *  @return State the account state
	 */
	  override public function get_accState(childID:uint):uint
	  {
	       var accState:uint = STATE_SYSTEM_NORMAL;
	         
	       if (AutoComplete(master).getFocus())
		   {	    
		  	   accState |= STATE_SYSTEM_FOCUSED;
		   }	  
		     		    
		   return accState;
	  }
				
     /**
	 *  Gets the role for the component.
	 *
	 *  @param childID the child id to fetch the account role
	 * 
	 * @return the account role
	 */
	  override public function get_accRole(childID:uint):uint
	  {
		  return ROLE_SYSTEM_TEXT ;
	   }
	  	
	 /**
	 *	Gets the array of events that we should listen for from the master component.
	 * 
	 * @return the array of events
	 */	
	  override protected function get eventsToHandle():Array
	  {
	      return super.eventsToHandle.concat(["valueCommit","change","enter","onFocus"]);
	  }
		
      /**
	  *  Override the generic event handler.
	  *  All AccImpl must implement this to listen for events
	  *  from its master component. 
	  * 
	  * @param event to be processed
	  */		
	  override protected function eventHandler(event:Event):void
	  {
	      switch (event.type)
		  {
  		     case "valueCommit":
			 {
			    Accessibility.sendEvent(master, 0,  EVENT_OBJECT_FOCUS);
			    Accessibility.sendEvent(master, 0,EVENT_OBJECT_SELECTION);
			   //Accessibility.sendEvent(master, 0,  EVENT_OBJECT_VALUECHANGE);
				Accessibility.updateProperties();
			    break;
			  }
			  case "enter":
			  {
			    Accessibility.sendEvent(master, 0,EVENT_OBJECT_SELECTION);
				Accessibility.updateProperties();
				break;
			  }				  
			  case "change":
			  {
			     Accessibility.sendEvent(master, 0,  EVENT_OBJECT_FOCUS);
			     Accessibility.sendEvent(master, 0,  EVENT_OBJECT_VALUECHANGE);
				 Accessibility.updateProperties();
				 break;
			  }	
			  case "onFocus":
			  {
			     Accessibility.sendEvent(master, 0,  EVENT_OBJECT_FOCUS);
				 Accessibility.updateProperties();
				 break;
		      }			
				   
	 	   }
		}
			
	}
}
