package gov.va.med.edp.widget.accessibility
{
	import mx.accessibility.AccImpl;
	import mx.controls.Label;
	import flash.events.Event;
	import flash.accessibility.Accessibility;
	import flash.accessibility.AccessibilityProperties;
	import mx.core.UIComponent;
	
	/**
     *  The AccessibleLabelAccImpl class is the accessibility class for 
     *  Accessible label component.
     *
     *  @tiptext This is the AccessibleLabelAccImpl Accessibility Class.
    */
	public class AccessibleLabelAccImpl extends AccImpl
	{
		/**
	    *  @private
	    */
		private static const EVENT_OBJECT_NAMECHANGE:uint = 0x800C;
		
		/**
		 *  @private
		 */ 
		private const ROLE_SYSTEM_STATICTEXT:uint = 0x29;
    
        /**
	    *  @private
	    *  Default Role of label component.
	    */
        private const ROLE_SYSTEM_TEXT:uint = 0x0000002A;
		
		/**
        *   Constructor for AccessibleLabelAccImpl class
        */
		public function AccessibleLabelAccImpl(master:UIComponent)
		{
			super(master);	
		}
		
		/**
	     *  Method call for enabling accessibility for a component.
	     *  this method is required for the compiler to activate
	     *  the accessibility classes for a component.
	    */
		public static function enableAccessibility():void
		{
		}
		
		/**
	     *  Method for returning the name of the accessible label
	     *
	     *  @param childID the child id used to get the name
	     *
	     *  @return Name the name to be returned
	    */
		override protected function getName(childID:uint):String
		{
			var label:String = IAccessibleComponent(master).accessibleText;		
			return label != null && label != "" ? label : "";
		}
        
        /**
	     *  Method for returning the state of the accessible label
	     *
	     *  @param childID the child id used to get the state
	     *
	     *  @return State the state to be returned
	     */
		override public function get_accState(childID:uint):uint
		{
			var accState:uint = getState(childID);

			return accState;
		}
		
		/**
	    *  Gets the role for the component.
	    *
	    *  @param childID the child id used to get the role
        * 
		*  @return State the state to be returned
	    */
	    override public function get_accRole(childID:uint):uint
	    {
		   return ROLE_SYSTEM_TEXT ;
	    }
		
	    /**
	     *	Gets the events that we should listen for from the master component.
		 * 
		 * @return Array the array of events for the master component
	    */	
		override protected function get eventsToHandle():Array
		{
			return super.eventsToHandle.concat(["labelChanged"]);
		}
		
		/**
	     *  Override the generic event handler.
	     *  All AccImpl must implement this to listen for events
	     *  from its master component.
		 * 
		 * @param event the event to be processed 
	     */	
		override protected function eventHandler(event:Event):void
		{
			switch (event.type)
			{
				/* tell JAWS to update and reread the information */
				case "accessibleTextChanged":
				{
					Accessibility.sendEvent(master, 0, EVENT_OBJECT_NAMECHANGE);
					Accessibility.updateProperties();
					break;
				}
			}
		 }
		
	
	}
}