package gov.va.med.edp.widget {

	import flash.display.Sprite;

	

	import mx.effects.Fade;

	
	/**
	 *  The spinner ticker class
	 */
	public class Tick extends Sprite {

		private var tickFade:Fade = new Fade(this);

		

		/**
		 *  Constructor for Spinner ticker for loading
		 * @param fromX
		 * @param fromY
		 * @param toX
		 * @param toY
		 * @param tickWidth
		 * @param tickColor
		 */

		public function Tick(fromX:Number, fromY:Number, toX:Number, toY:Number, tickWidth:int, tickColor:uint) {

			this.graphics.lineStyle(tickWidth, tickColor, 1.0, false, "normal", "rounded");

			this.graphics.moveTo(fromX, fromY);

			this.graphics.lineTo(toX, toY);

		}

		

		/**
		 *  Spinner ticker for loading
		 * @param duration for spinning
		 *
		 */

		public function fade(duration:Number):void {

			tickFade.alphaFrom = 1.0;

			tickFade.alphaTo = 0.1;

			tickFade.duration = duration;

			tickFade.play();

		}

	}

}