package gov.va.med.edp.widget
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.ProgressEvent;
	import flash.filters.DropShadowFilter;
	import gov.va.med.edp.model.TrackingModelLocator;
	import mx.events.FlexEvent;
	import mx.preloaders.DownloadProgressBar;

	/** 
	 * This class is used as a progress bar by extending the mx DownloadProgressBar control.
	 */
	public class Pre extends DownloadProgressBar
	{
		private var cp:customPreloaderEDIS;
		
		/** 
		 * This tracking model locator.
		 */
		
		[Bindable]
		public var model:TrackingModelLocator = TrackingModelLocator.getInstance();
	
		/** 
		 * Constructor for Pre class.
		 */
		public function Pre()
		{
			cp = new customPreloaderEDIS();
			cp.filters = [new DropShadowFilter(4, 45, 0, 0.5)];
			addEventListener(Event.ADDED_TO_STAGE, onAdded);
			cp.version.text = "v" + model.appClientVersion;
			addChild(cp);
		}
		
		/** 
		 * Setter for preloader.
		 * 
		 * @param preloader  the preloader value
		 */
		public override function set preloader(preloader:Sprite):void
		{
			preloader.addEventListener(ProgressEvent.PROGRESS, onProgress);
			preloader.addEventListener(FlexEvent.INIT_COMPLETE, initComplete);
		}
		
		private function onProgress(e:ProgressEvent):void
		{
			cp.percent.text = Math.ceil(e.bytesLoaded/e.bytesTotal*100).toString() + "%";			
			cp.gotoAndStop(Math.ceil(e.bytesLoaded/e.bytesTotal*100));
		}
		
		private function initComplete(e:Event):void
		{
			dispatchEvent(new Event(Event.COMPLETE));
		}
		
		private function onAdded(e:Event):void
		{
			cp.stop();
			cp.x = stage.stageWidth*0.5 - 135;
			cp.y = stage.stageHeight*0.5 - 34;
		}
		
	}
}
