package gov.va.med.edp.widget
{
	import gov.va.med.edp.skins.LinkButtonTabSkin;
	
	import mx.controls.Button;
	import mx.core.mx_internal;
	import mx.styles.CSSStyleDeclaration;
	import mx.styles.StyleManager;
	
	use namespace mx_internal;
	
	/** 
	 * This class is used to create a link button tab by extending the mx Button control.
	 */
	public class LinkButtonTab extends Button
	{
		private static var classConstructed:Boolean = classConstruct();
	
		/**
		 *  If there is no CSS definition for our style,
		 *  then create one and set the default value.
		 * Class constroctor
		 */
		private static function classConstruct():Boolean {
			
			
			if (!StyleManager.getStyleDeclaration("LinkButtonTab"))
			{
				var style:CSSStyleDeclaration = new CSSStyleDeclaration();
				style.defaultFactory = function():void {
					this.skin = LinkButtonTabSkin;
					
					this.upSkin = LinkButtonTabSkin;
					this.downSkin = LinkButtonTabSkin;
					this.disabledSkin = LinkButtonTabSkin;
					this.overSkin = LinkButtonTabSkin;
					this.selectedUpSkin = LinkButtonTabSkin;
					this.selectedDownSkin = LinkButtonTabSkin;
					this.selectedOverSkin = LinkButtonTabSkin;
					this.selectedDisabledSkin = LinkButtonTabSkin;				
				}
				StyleManager.setStyleDeclaration("LinkButtonTab", style, true);
			}
			return true;
		}
			
		/**
		 * Constructor for LinkButtonTab class.  
		 * Tabs are not tab-enabled.
		 * The TabNavigator handles all focus management.
		 */
		public function LinkButtonTab()
		{
			super();
			// Tabs are not tab-enabled.
			// The TabNavigator handles all focus management.
			focusEnabled = false;
		}

		/**
		 * Sets the width and height of the children.
		 * 
		 * @param unscaledWidth  the width
		 * @param unscaledHeight the height
		 */	
		override protected function updateDisplayList(unscaledWidth:Number,
												  unscaledHeight:Number):void
		{
			super.updateDisplayList(unscaledWidth, unscaledHeight);
	
			if (currentIcon)
			{
				currentIcon.scaleX = 1.0;
				currentIcon.scaleY = 1.0;
			}
	
			viewIcon();
		}
	}
}