package gov.va.med.edp.widget
{
	import gov.va.med.edp.skins.LinkButtonTabSkin;
	
	import mx.controls.Button;
	import mx.core.mx_internal;
	import mx.styles.CSSStyleDeclaration;
	import mx.styles.StyleManager;
	
	use namespace mx_internal;
	
	/** 
	 * This class is used to create a link by extending the mx Button control.
	 */
	public class LinkButton extends Button
	{

		private static var classConstructed:Boolean = classConstruct();
		/**
		 * Class constructor
		 */
		private static function classConstruct():Boolean {
			// If there is no CSS definition for our style,
			// then create one and set the default value.
			
			if (!StyleManager.getStyleDeclaration("LinkButton"))
			{
				var style:CSSStyleDeclaration = new CSSStyleDeclaration();
				style.defaultFactory = function():void {
					this.emphasized = false;
					this.skin = "mx.skins.halo.LinkButtonSkin";
					this.upSkin = "mx.skins.halo.LinkButtonSkin";
					this.downSkin = "mx.skins.halo.LinkButtonSkin";
					this.disabledSkin = "mx.skins.halo.LinkButtonSkin";
					this.overSkin = "mx.skins.halo.LinkButtonSkin";
					this.selectedUpSkin = "mx.skins.halo.LinkButtonSkin";
					this.selectedDownSkin = "mx.skins.halo.LinkButtonSkin";
					this.selectedOverSkin = "mx.skins.halo.LinkButtonSkin";
					this.selectedDisabledSkin = "mx.skins.halo.LinkButtonSkin";					
				}
				StyleManager.setStyleDeclaration("LinkButton", style, true);
			}
			return true;
		}


	
		/**
		 *  Class constructor for LinkButton class. Because of the accessibility bug with LinkButtons, Make them Button components 
		 * like link buttons for common look and feel link
		 */
		public function LinkButton()
		{
			super();
		}

	}
}