package gov.va.med.edp.widget
{
	import flash.events.Event;
	import flash.display.DisplayObject;

	/** 
	 * This class is used to capture changes in indexes for a related object triggered by an event.
	 */
	public class IndexesChangedEvent extends Event
	{
		
		
		public static const CHANGE			: String = "indexesChange";
		
		private var _releatedObject		: DisplayObject;
		private var _oldIndexes			: Array;
		private var _newIndexes			: Array;
		private var _trigger			: Event;
	
		/** 
		 * Constructor for IndexesChangedEvent class.
		 */
		public function IndexesChangedEvent( type:String, bubbles:Boolean = false, cancelable:Boolean = false, releatedObject:DisplayObject = null, oldIndexes:Array = null, newIndexes:Array = null, trigger:Event = null )
		{
			super( type, bubbles, cancelable );
			
			_releatedObject = releatedObject;
			_oldIndexes = oldIndexes;
			_newIndexes = newIndexes;
			_trigger = trigger;
		}
		
		/** 
		 * Gets the related object.
		 * 
		 * @return DisplayObject the related object.
		 */
		public function get releatedObject():DisplayObject
		{
			return _releatedObject;
		}
		
		/** 
		 * Gets the old indexes.
		 * 
		 * @return Array  the old indexes array.
		 */
		public function get oldIndexes():Array
		{
			return _oldIndexes;
		}
	
		/** 
		 * Gets the new indexes.
		 * 
		 * @return Array  the new indexes array.
		 */
		public function get newIndexes():Array
		{
			return _newIndexes;
		}
		
		/** 
		 * Gets the triggering event.
		 * 
		 * @return Event  the triggering event.
		 */
		public function get trigger():Event
		{
			return _trigger;
		}

		/** 
		 * The clone event executed by flex.
		 * 
		 * @return Event  the index change event.
		 */
		public override function clone():Event
		{
			return new IndexesChangedEvent( type, bubbles, cancelable, releatedObject, oldIndexes, newIndexes, trigger );
		}
	}
}