/* GapAccordion.as

In Flex 2 there is a bug that causes the verticalGap to not be included in the
measurement calculations for the child containers in the accordion.  This
adds the verticalGap back in.

See:  http://adamflater.blogspot.com/2007/08/accordion-bug.html

 */
 
package gov.va.med.edp.widget
{
	import mx.containers.Accordion;

	/**
	 * This is an extension of the Accordion container class.
	 *  
	 */
	public class GapAccordion extends Accordion
	{
	
		/**
		 * Sets the measurements of the container such as height.
		 */
		override protected function measure():void
		{
			super.measure();
			this.measuredHeight += (this.getStyle("verticalGap") * this.numChildren);
		}
		
	}
}