package gov.va.med.edp.widget
{
	import mx.containers.FormItem;
	import mx.styles.StyleManager;
	
	/**
	 * This is an extension of the FormItem that enables the setting of all
	 * typical css styles.
	 *  
	 * @author useruseruser12
	 * 
	 */
	public class ExtStyleFormItem extends FormItem
	{
		/**
		 * Constructor for ExtStyleFormItem class.
		 */
		public function ExtStyleFormItem()
		{
			super();
			// Must override this per class and it must match the css style in edp.css
			this.styleName = "extStyleFormItem";
		}
		
		/**
		 * This method makes styles "width", "height", "percentWidth", "percentHeight", "x", "y" and "visible"
		 * valid from css.
		 * 
		 * @param styleProp  the style property to be set
		 */
		override public function styleChanged(styleProp:String):void{
			super.styleChanged(styleProp);
			if(!styleProp || styleProp == "styleName"){
				//if runtime css swap or direct change of stylename
				var classSelector:Object = StyleManager.getStyleDeclaration("." + styleName);
				if(classSelector != null){
					applyProperties(classSelector, ["width", "height", "percentWidth", "percentHeight", "x", "y", "visible"]);
				}
			}
		}
		
		private function applyProperties(styleObj:Object, arr:Array):void{
			for each (var item:String in arr){
				var prop:Object = styleObj.getStyle(item);
				if(prop != null) this[item] = prop;
			}
		}
	}
}