/* ColorCellRenderer.as */

package gov.va.med.edp.widget
{
	import flash.display.Graphics;
	
	import gov.va.med.edp.model.TrackingModelLocator;
	
	import mx.controls.Label;
	
	/**
	 *  This class extends the mx label control class in order to display cell color and text.
	 */
	public class ColorCellRenderer extends Label
	{	
		[Bindable]
		private var model: TrackingModelLocator = TrackingModelLocator.getInstance();

		/**
		 *   Constructor for ColorCellRenderer class.
		 */
		public function ColorCellRenderer() 
		{
		}
		
		/**
		 *  Setter to set data
		 * 
		 * @param value  the value object to be set
		 */
		override public function set data(value:Object):void
		{
			super.data = value;

			if (value != null)
			{
				setStyle("color", model.boardSpec.cellColor(listData["dataField"], value).text);
				setStyle("textAlign", "left");
				
				if (model.appName == TrackingModelLocator.APP_NAME_BIGBOARD) {
					setStyle("fontSize", model.boardSpec.displayBoardProperties.squishFontSize);					
				}
			}
		}
		
		/**
		 *  Updates the display list
		 * 
		 * @param unscaledWidth   the width
		 * @param unscaledHeight  the height
		 */
		override protected function updateDisplayList(unscaledWidth:Number, unscaledHeight:Number):void
		{
			super.updateDisplayList(unscaledWidth, unscaledHeight);
			
			if (data != null) {
				var backColor: uint = model.boardSpec.cellColor(listData["dataField"], data).back;
				var g:Graphics = graphics;
				g.clear();
				g.beginFill(backColor);
				//g.drawRect(0, -2, unscaledWidth, unscaledHeight+4);
				g.drawRect(0, 0, unscaledWidth, unscaledHeight);
				g.endFill();				
			}
		}
	}
}