package gov.va.med.edp.widget
{
	import flash.display.DisplayObject;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	
	import mx.controls.CheckBox;
	import mx.controls.dataGridClasses.DataGridListData;
	import mx.controls.listClasses.IListItemRenderer;

	/** 
	 * This class extends the mx CheckBox control class in order to set and access selected data.
	 */		  
	public class CenteredCheckBox extends CheckBox implements IListItemRenderer
	{

		private var _data: Object;
		
		/**
		 *   Constructor for CenteredCheckBox class.
		 */
		public function CenteredCheckBox() 
		{
		}
		/**
		 * Setter for data
		 * 
		 * @param value  the data to be set
		 */
        override public function set data(value:Object):void
        {
        	if(value != null) {
        		super.data = value;
        		_data = value;
        		var dataField: Object = DataGridListData(listData).dataField;
        		selected = value[dataField];
        	} else {
        		selected = false;
        	}
        }
        
		/**
		 * Getter for data
		 * 
		 * @return  the data to be returned
		 */
		override public function get data(): Object
		{
			return _data;
		}        

		/**
		 * The handler for click event
		 * 
		 * @param event  the mouse event
		 */
        override protected function clickHandler(event:MouseEvent):void
        {
            super.clickHandler(event);
            data[DataGridListData(listData).dataField] = selected;
        }		
		
		/**
		 * Centers the content holder
		 * 
		 * @param w  the width
		 * @param h  the height
		 */		
        override protected function updateDisplayList(w:Number, h:Number):void
        {
        	super.updateDisplayList(w, h);

            var n:int = numChildren;
            for (var i:int = 0; i < n; i++)
            {
            	var c:DisplayObject = getChildAt(i);
            	if (!(c is TextField)) {
                	c.x = (w - c.width) / 2;
                    c.y = 0;
                }
            }
        }		
	}
}
