package gov.va.med.edp.widget
{
	import flash.events.Event;
	import flash.events.FocusEvent;
	
	import gov.va.med.edp.util.AccessibilityTools;
	import gov.va.med.edp.widget.accessibility.AccessibleLabelAccImpl;
	import gov.va.med.edp.widget.accessibility.IAccessibleComponent;
	
	import mx.controls.Label;
	import mx.managers.IFocusManagerComponent;
       
    /** 
     * This class extends the mx Label class  in order to make them focusable.
     * For a user with a screen reader, if the image is critical to the application
     * you will need to have some way to communicate a summary of the image's information
     * to a screen reader.
     *
     * You can check if a screen reader is being used to make this component
     * behave like the standard label component so a user that does not need
     * accessibility features will not see the tooltips or be able to tab
     * to label components.
     */
	public class AccessibleLabel extends Label 
	    implements IFocusManagerComponent, IAccessibleComponent 
	{
		/**
	    *  @private
	    */
		private var _accessibleText:String = "";
				
	   /**
       *   Constructor for AccessibleLabel class
       */
		public function AccessibleLabel() 
		{
			super();
		}
		
		/**
	     *  Method to set accessible text.
		 * 
		 * @param  the accessible text
	     */
		public function set accessibleText(s:String):void
		{
			_accessibleText = s;
			dispatchEvent(new Event("accessibleTextChanged"));
		}
		
		/**
	     *  Method to get accessible text.
		 * 
		 * @return  the accessible text
	     */
		public function get accessibleText():String
		{
			return _accessibleText;
		}
		
		/** 
		 * The properties are set on creation complete.  
		 * accessibilityProperties will be guaranteed 
		 * to be accurate at this point 
		 * and the accessibility changes
		 * can be made accordingly. 
		 **/
		override protected function commitProperties():void
		{
			
			if ((accessibilityProperties != null) 
			   && (AccessibilityTools.isAccessibilityActive()))  
			{
				focusEnabled = true;
				tabEnabled = true;
				accessibilityImplementation = new AccessibleLabelAccImpl(this);
				setStyle("focusThickness", 2);
				
			}
			else 
			{
				focusEnabled = false;
				tabEnabled = false;
				removeEventListener(FocusEvent.FOCUS_IN, focusInHandler);
				removeEventListener(FocusEvent.FOCUS_OUT, focusOutHandler);
			}
		}
		
		/**
		 *  Method that handles focus in events
		 * 
		 * @param  the focus event to be processed 
		 */
		override protected function focusInHandler(event:FocusEvent):void 
		{
			_accessibleText = (_accessibleText == "" ? text : _accessibleText); 
		   
		    // revised by jtorreno 07/29/2008
		    // fix for null error exception if component is null 
		    if ((focusManager != null) && (focusManager.getFocus() != null))
		    {
		        drawFocus(true);
		    }   
		   
			event.stopPropagation();
		}
		
			        
	}
}

