/* WorkSheetListVO.as */
	
package gov.va.med.edp.vo.worksheet
{
	import com.adobe.cairngorm.vo.IValueObject;

	[Bindable]
	/**
	 * Holds the worksheet list entries. 
	 */
	public class WorkSheetListVO implements IValueObject
	{
		/**
		 * The data entry. 
		 */
		public var data: Number;
		/**
		 * The id of the workseet. 
		 */
		public var id: Number;
		/**
		 * The worksheet name. 
		 */
		public var worksheetName: String;
		/**
		 * The type of worksheet. 
		 */
		public var type: String;
		/**
		 * The disabled entry. 
		 */
		public var disabled: String;
		/**
		 * The label entry. 
		 */
		public var label: String;
		/**
		 *   Constructor.
		 */
		public function WorkSheetListVO() 
		{
		}
		/**
		 * Returns the string representation of worksheet list entries.
		 *  
		 * @return  String  the string of worksheet list entries
		 * 
		 */
		public function toString():String
		{
		var x: String = 
			"data = " + data + "\t" +
			"id = " + id + "\t" +
			"worksheetName = " + worksheetName + "\t" +
			"label = " + label + "\t" +
			"disabled = " + disabled + "\t" +
			"type = " + type;
			return x;
		}
		
	}
}