package gov.va.med.edp.vo.worksheet
{
	import com.adobe.cairngorm.vo.IValueObject;
	import gov.va.med.edp.vo.worksheet.ComponentVO;
	
	/**
	 * Holds the section information
	 * 
	 * @author useruseruser12
	 * 
	 */
	public class SectionVO implements IValueObject
	{
		
		/**
		 * Contains the detail plugin name.
		 */
		public var name: String;
		/**
		 * Contains the package information.
		 */
		public var packageInformation: String;
		/**
		 * Contains the default display name.
		 */
		public var defaultDisplayName: String;
		/**
		 * Contains the summary plugin information.
		 */
		public var summary: String;
		/**
		 * Contains the task type.
		 * <p>
		 * 0 - None
		 * 1 - Checkbox
		 * 2 - Timed
		 * </p>
		 */
		public var taskType: String;
		/**
		 * Contains the initially opened state.
		 * <p>
		 * 0 - False
		 * 1 - True
		 * </p>
		 */
		public var initiallyExpanded: String;
		/**
		 * Signifies what position this section resides in within the worksheet.
		 */
		public var sequence: int;
		/**
		 * The components within this section. 
		 */
		public var componentVOArray:Array = [];
		/**
		 * Constructor
		 * 
		 */
		public function SectionVO()
		{
			
		}
		
		/**
		 * Returns the string representation of this object.
		 * @return String - The string representation of this object
		 * 
		 */
		public function toString():String
		{
			var x: String = 
				"name=" + name + "\t" +
				"packageInformation=" + packageInformation + "\t" +
				"defaultDisplayName=" + defaultDisplayName + "\t" + 
				"summary=" + summary + "\t" + 
				"taskType=" + taskType + "\t" + 
				"initiallyExpanded=" + initiallyExpanded + "\t";
			return x;
		}
	}
}