package gov.va.med.edp.vo.worksheet
{
	import com.adobe.cairngorm.vo.IValueObject;
	import mx.collections.ArrayCollection;
	
	[Bindable]
	/**
	 * Holds the worksheet abstract worksheet data
	 * @author useruseruser12
	 * 
	 */
	public class AbstractWorkSheetVO implements IValueObject
	{
		
		/**
		 * Contains the name of worksheet.
		 */
		public var name: String;
		/**
		 * Contains the institution of worksheet.
		 */
		public var institution: String;
		/**
		 * Contains the tracking area of worksheet.
		 */
		public var area: String;
		/**
		 * Contains the type of worksheet.
		 * <p>
		 * V - for Visit
		 * A - for Assess
		 * P - for Plan
		 * </p>
		 */
		public var type: String;
		/**
		 * Contains the role associated with this worksheet.
		 */
		public var role: String;
		/**
		 * This indicates whether this worksheet is disabled or not.
		 * <p>
		 * 0 - False
		 * 1 - True
		 * </p>
		 */
		public var disabled: String;
		
		/**
		 * The sections associated with this worksheet.
		 */
		public var sectionsVO:ArrayCollection = new ArrayCollection();
		
		/**
		 * Constructor
		 * 
		 */
		public function AbstractWorkSheetVO()
		{
			//TODO: implement function
		}
		
		/**
		 * Returns the string representation of this object.
		 * @return String - The string representation of this object
		 * 
		 */
		public function toString():String
		{
			var x: String = 
				"name=" + name + "\t" +
				"institution=" + institution + "\t" +
				"area=" + area + "\t" + 
				"type=" + type + "\t" + 
				"role=" + role + "\t" + 
				"disabled=" + disabled + "\t";
			return x;
		}				
		
	}
}