/* AdhocReportSearchParametersVO.as */

package gov.va.med.edp.vo.reports.adhoc
{
	import com.adobe.cairngorm.vo.IValueObject;
	
	import mx.collections.ArrayCollection;
	
	[Bindable]
	/**
	 * Holds the adhoc report search parameters. 
	 * @author Joseph Lemaire
	 * 
	 */
	public class AdhocReportSearchParametersVO implements IValueObject
	{
		/**
		 * The id of parameter.
		 *  
		 */
		public var id: String = '';
		/**
		 * The area parameter.
		 *  
		 */
		public var area: int;
		/**
		 * The resident parameter.
		 *  
		 */
		public var resident: String;
		/**
		 * The patient parameter.
		 *  
		 */
		public var patient:String;
		/**
		 * The csv file parameter.
		 *  
		 */
		public var csv:String;
		/**
		 * The report start date parameter.
		 *  
		 */
		public var startDate:Date;
		/**
		 * The report end date parameter.
		 *  
		 */
		public var endDate:Date;
		/**
		 * The report name parameter.
		 *  
		 */
		public var reportName:String;

		/**
		 * The elements associated with this report.
		 */
		public var elements:ArrayCollection = new ArrayCollection();
		
		/**
		 *   Constructor.
		 */
		public function AdhocReportSearchParametersVO() 
		{
		}
		
//		public function toString():String
//		{
//			var x: String = 
//				"id = " + id + "\t" +
//				"inactive = " + inactive + "\t" +
//				"name = " + name;
//			"label = " + label;
//			return x;
//		}		
	}
}