/* ReportParamsVO.as */
	
package gov.va.med.edp.vo.reports
{
	import com.adobe.cairngorm.vo.IValueObject;
	
	import gov.va.med.edp.util.Vista;

	[Bindable]
	/**
	 * Holds the report parameters. 
	 */
	public class ReportParamsVO implements IValueObject
	{
		/**
		 * The report name entry. 
		 */
		public var reportName: String;
		/**
		 * The id of the report. 
		 */
		public var id: String;
		/**
		 * The start date. 
		 */
		public var startDate: Date;
		/**
		 * The stop date. 
		 */
		public var stopDate: Date;
		/**
		 * The resident name entry. 
		 */
		public var residentName: String;
		/**
		 * The patient id entry. 
		 */
		public var patientId: String;
		
		/**
		 *   Constructor.
		 */
		public function ReportParamsVO() 
		{
		}
		
		/**
		 * Returns the string representation of report parameters.
		 *  
		 * @return  String  the string of report parameters
		 * 
		 */
		public function toString():String
		{
				var x: String = "reportName=" + reportName + "\t" +
				"id=" + id + "\t" +
				"startDate=" + Vista.DatetoFM(startDate) + "\t" +
				"stopDate=" + Vista.DatetoFM(stopDate) + "\t" +
				"residentName=" + residentName + "\t" +
				"patientId=" + patientId;
				return x;
		}	
	
	}
}